EEPort		equ	Port2  		;Verwendeter Port virtuell
EEscl		bit	EEPort.1	;Verwendete Bits
EEsda		bit	EEPort.0	;Verwendete Bits
EESlvAddr	equ	0101b
EEAckRead	equ	10000101b

;------------------------------------------------------------------------------
		DSEG

EEBlockAddr:	ds	1	;Speicher fuer HI EEpromadresse
EEByteAddr:	ds	1	;Speicher fuer LO EEpromadresse
EEByteData:	ds	1	;Speicher fuer Daten in der Adresse

;------------------------------------------------------------------------------
		CSEG
;Setzen der EEpromadresse fuer den Schreib- oder Lesevorgang
;
EESetAddr:
	push	dph
	push	dpl
	mov	EEBlockAddr,dph		;hoeherwertiges Byte der Adresse
	mov	EEByteAddr,dpl		;niederwertiges Byte der Adresse
	pop	dpl
	pop	dph
	ret

;Schreiben eines Bytes in den EEprom
;Adresse in Register DPTR
;Byte in Register A

EEWrite:
	push	acc
	anl	psw,#11111111b	;auf Registerbank 4 schalten
	orl	psw,#00011000b
	call	EESetAddr
	mov	EEByteData,a
	call	EEByteWrite
	call	EERead
	anl	psw,#11100111b	;zurck auf Registerbank 0
	pop	acc
	ret

;Lesen eines Bytes aus den EEprom
;Adresse in Register DPTR
;Byte in Register A

EERead:
	anl	psw,#11111111b	;auf Registerbank 4 schalten
	orl	psw,#00011000b
	call	EESetAddr
	call	EESelectRead
	mov	a,EEByteData
	anl	psw,#11100111b	;zurck auf Registerbank 0
	ret

;--------------------------- BYTE WRITE ---------------------------------------
EEByteWrite:
	call	EEStartBit		;send StartBit
	mov	a,#EESlvAddr
	mov	r7,#4
	call	EESHFTO
	mov	a,EEBlockAddr
	mov	r7,#3
	call	EESHFTO
	mov	a,#0
	mov	r7,#1
	call	EESHFTO
	call	EESlaveAck
	mov	a,EEByteAddr
	mov	r7,#8
	call	EESHFTO
	call	EESlaveAck
	mov	a,EEByteData
	mov	r7,#8
	Call	EESHFTO
	call	EESlaveAck
	call	EEStopBit
	call	EEAckPol
	ret
;------------------------------------------------------------------------------
EEAckPol:
	mov	r3,#40h
EEAckLoop:
	djnz	r3,EEDoneYet
	sjmp	EEDnAckPol
EEDoneYet:
	call	EEStartBit
	mov	a,#EEAckRead
	mov	r7,#8
	call	EESHFTO
	call	EESlaveAck
	jc	EEAckLoop
EEDnAckPol:
	call	EEStopBit
	ret
;------------------------------------------------------------------------------
EESHFTO:
	clr	EEscl
EENxtShf:
	clr	EEScl
	rrc	a
	mov	EESda,c
	setb	EEScl
	djnz	r7,EENxtShf
	ret
;------------------------------------------------------------------------------
EEStartBit:
	nop
	nop
	setb	EEScl
	nop
	nop
	setb	EESda
	nop
	nop
	clr	EESda
	nop
	nop
	clr	EEScl
	nop
	nop
	ret
;------------------------------------------------------------------------------
EEStopBit:
	nop
	nop
	clr	EESda
	nop
	nop
	setb	EEScl
	nop
	nop
	setb	EESda
	nop
	nop
	ret
;------------------------------------------------------------------------------
EESlaveAck:
	nop
	nop
	nop
	nop
	clr	EEScl
	nop
	nop
	setb	EESda
	nop
	nop
	nop
	nop
	Setb	EEScl
	nop
	nop
	nop
	nop
	nop
	nop
	mov	c,EESda
	clr	EEScl
	nop
	nop
	ret
;------------------------------------------------------------------------------
EEMstrAck:
	nop
	nop
	clr	EEScl
	nop
	nop
	clr	EESda
	nop
	nop
	nop
	nop
	setb	EEScl
	nop
	nop
	clr	EEScl
	nop
	nop
	setb	EESda
	nop
	nop
	ret
;------------------------------------------------------------------------------
EENoAck:
	setb	EESda
	nop
	nop
	setb	EEScl
	nop
	nop
	clr	EEScl
	ret
;------------------------------------------------------------------------------
EESelectRead:
	call	EEStartBit
	mov	a,#EESlvAddr
	mov	r7,#4
	call	EESHFTO
	mov	a,EEBlockAddr
	mov	r7,#3
	call	EESHFTO
	mov	a,#0
	mov	r7,#1
	call	EESHFTO
	call	EESlaveAck
	mov	a,EEByteAddr
	mov	r7,#8
	call	EESHFTO
	call	EESlaveAck
	call	EEStartBit
	mov	a,#EESlvAddr
	mov	r7,#4
	call	EESHFTO
	mov	a,EEBlockAddr
	mov	r7,#3
	call	EESHFTO
	mov	a,#1
	mov	r7,#1
	call	EESHFTO
	call	EESlaveAck
	mov	r7,#8
EEClock8:
	setb	EEScl
	nop
	nop
	mov	c,EESda
	clr	EEScl
	mov	a,EEByteData
	rrc	a
	mov	EEByteData,a
	djnz	r7,EEClock8
	call	EENoAck
	call	EEStopBit
	call	EEStopBit
	ret
;------------------------------------------------------------------------------
