$XR
$NOPI




; obecna wersja wersja  1.51.03

;==================

;Lista zmian wprowadzonych przez SP2SWJ 2005-03-14
;Tumaczenie i pozycjonowanie tekstw  (instrukcja w przygotowaniu...
; 
;     |------------------Wskaznik aktywnego VFO
;     |         |--------Wskaznik zalaczaniA funkcji szybkiego przestrajania
;     |         |  |-----Informacja o wybranym trybie pracy  CW,LSB,USB CWn waskie CW
;     |         |  |     W trybie FSK  pokazuje si  FSK und FSR dla odwrotnego trybu
;     |         |  |
;  -------------------
;  |A>  3,552.230*Mhz|
;  |B   3,560.000 RNB|
;  -------------------
;                 |||
;                 |||---Blokowanie przestrajania
;                 ||----Tryb nadawania aktywny
;                 |-----Rit zalaczony
;                 |-----Split zalaczony
;
;Poprawiono probelem z inicjalizacja niektorych LCD - dodana druga linijka 
;inicjalizacji LCD  rozwiazala problem - za drugom inicjalizacja LCD  zawsze wlacza sie poprawnie
;  niestety nie starczylo czasu na zmiane "timingow"  inicjalizacj LCD  aby zrobic to elegancko
;
;
;Ustawiono domysle budzenie sie na pasmie 3,5 MHz w trybie sterowania pasmami
;
;Ustawiono MENU  domyslne na komende WYJSCIE z MENU  a nie jak dotychczas 
;zmian posredniej CW
;
;
; dodana obsluga AD9851  z mnoznikiem x6   ---- ZROBIONE przetestowane
; naley zdefiniowa przed kompilacj programu  - poszuka cigu   "mnoznik 6x"
;
;--- 2005-04-04 dodano wyswietlanie na LCD  
;  -  informacji w trybie RIT i SPLIT ktore f  jest TX a ktore RX
;  -  wczono blokowanie przestarajania   podczas aktywnego nadawania
;  -  nadawanie wykrywane jest z lini klucza CW
;  -  dla tybu FSK  tylk jeden pin klucza aktywuje TX
;
;----  2005-05-22  poprawiono bd inicjalizacji ukadow AD9851 w trybie mnoenia  6x
;  - dodane ladowanie 5 x 00h  do DDSa odrazu po wlaczeniu
;
;
;----  2005-05-29  dodano obsluge klawisza  RIT  i PASMOUP  i ...
; - dwa piny wolne (mialy byc do RS232)  zastosowano do funkcji 
;  > > RIT 
;  > > i zmiana pasma (band_UP)
; zrobiono  zapamietanie ostatnio uzywanego pasma  
;      dzieki ci Balinus1 !!
;
;----  2005-05-31   
; - zmieniono  tryb z pominiciem poredniej tak aby pracowa tylko z CW  - a nie generalnie
;
; poprawiono dziaanie funkcji  ESCAPE  z menu konfiguracyjnego
; przy zmianie pasma  BAND-UP  zapamietywanie jest F-LCD  jak F jest z zakresu  HAM bandplanu
; Dodano zapamietywanie F-LCD   po nacicniciu przycisku nadawania PTT  
;   ----  USUNIETE w wersji 1.50
;
; 
; ========================================1-41 
; dodany krok strojenia 1 Hz
; dodane klawisze funkcyjne - odczyt binarny klawiatury = dodatkowe 4 klawisze
;nowe funkcje podczone s pod klawisze  
;12          band down
;   34    band up
; 23      RIT    
;1   4    SPLIT  

; 2005-10-10 ======================================= 1-50
; - sterowanie wstegami z MENU  LSB USB CW   za  pomoc  klawisza
;1 3    MODE UP  
; 
; 1-50-03 dodane klawisze  4-2 zapis VFO  LCD
; 1-51.00 poprawiono klawisze dla  GENERATORA
; 1-51.01 poprawiono dzialnie klaiwszy  BAND UPDOWN
; 1-51.02 poprawiono dzialanie klawisza MODE
; 1-51.03 poprawiono zakresy pasm i wyciagnieto do pliki INC




;---------------------------------------------------------------------------
;Register einfuegen


$INCLUDE (REG89C52.INC)
;---------------------------------------------------------------------------
;###########################################################################
;Alle Einsprungadressen definieren
;Das CODE-Segment genau definieren

	CSEG
	ORG	0

	ljmp	start		;Einsprung in den Start des Programmes

	org	03h		;hier liegen die Interrupteinspruenge
	ljmp	intext0
	org	0bh
	ljmp	inttimer0
	org	13h
	ljmp	intext1
	org	1bh
	ljmp	inttimer1
	org	23h
	ljmp	intrs232
	org	2bh
	ljmp	inttimer2
	org	43h
	ljmp	intadwandler
	org	4bh
	ljmp	intext2
	org	53h
	ljmp	intext3
	org	5bh
	ljmp	intext4
	org	63h
	ljmp	intext5
	org	6bh
	ljmp	intext6
;--------------------------------------------------------------------
	ORG	6eh		;erste freie adresse nach inteinspruengen

;------------------------------------------------------------------
;Das interne DATA-Segement definieren
		DSEG
		ORG	30H

;------------------------------------------------------------------
;Das interne BIT-Segement definieren
		BSEG
		ORG	0H
;==================================================================
;
;##################################################################
;
;HIER WERDEN ALLE INCLUDE-FILES EINGEFUEGT !!!!!
;
$include (lcd4n.inc)
$include (eeprom2.inc)
$include (tastenl.inc)
;
;##################################################################
;
;##################################################################
;
;AB HIER WERDEN DIE VARIABLEN DEFINIERT
;
;##################################################################
;Flags und Bytes zur Programmsteuerung
;
flag0		equ	20h	;Adressen interner Ram fuer Flags
flag1		equ	21h	;zum Abspeichern im EEprom


;========================================================== definicje w innym pliku
$include (def0.inc)


;========================================================== makro w zewntrznym pliku
$include (lcdxy.inc)

		CSEG

;##################################################################
;
;AB HIER BEGINNT DER PROGRAMMCODE
;
;##################################################################
;Jeder Interrupt der nicht benutzt wird endet in einem Neustart
;Interrupteinspruenge der nicht benutzten interrupts
;Benutzte Interrupts mit einem Semicolon sperren
;Anschliessend muessen dafuer Proceduren geschrieben werden sonst
;kommt es zur Fehlermeldung
;intext0:
;inttimer0:
;intext1:
;inttimer1:
intrs232:
inttimer2:
intadwandler:
intext2:
intext3:
intext4:
intext5:
intext6:

start:
	call	ddsinit                 ;AD9850 initialisieren
	mov	r0,#0			;internen ram loeschen
	clr	a
st1:
	mov	@r0,a
	inc	r0
	cjne	r0,#80h,st1		;nur die ersten 128 byte
			 		;Sperren der Interrups MC-abhaengig
	%InterruptSperren
	mov	psw,#0
	mov	sp,#ramende		;stack an das ramende legen

	%InitLCD('DL4JAL by SWJZDZ', ' Version 1.51.03 ')

$include (welcome.inc)

; xxxx ustawianie MENU domyslengo  na 24 pozycje - WYJSCIE z MENU

	MOV	Menutaste1,#24


;Funkcje PowerON

	call	TasteStatus		;Abfangen der PowerOn-Funktionen
	cjne	a,#3,st2		;? Taste 3
	%WriteStrXY(1,1,'Kasowanie EEPROM')
	%WriteStrXY(1,2,'Pusc klawisz')
	call	TasteInput
	%WriteStrXY(1,2,'poczekaj 20 sek.')
	MOV 	DPTR,#0			;1 Loeschen des Eeproms - kasowanie  epromu
st3:
	mov	a,#0ffh
	call	EEWrite
	inc	dptr
	mov	a,dph
	cjne	a,#8,st3		

st2:					;0
	call	TRXInit                 ;Interrupt, Frequenz usw. einstellen

; = = = = = = = = = = = =   Odczyt ustawien z pamieci EPROM flash

run:               			;Pollingschleife
	mov	a,TimerLock		;? Zeit fuer Lock zuende
	jnz	run01			
	setb	BNoLock			;1 Bit dafuer setzen  (no Lock)
	sjmp	run001
run01:
	clr	BNoLock			;0 Bit loeschen (Lock)
run001:
	mov	a,TimerSenderAus	;? Zeit fuer Sender aus abgelaufen
	jnz	run02			
	setb	SenderAus		;1 Bit fuer Sender aus setzen (Empf)


; SWJ               chyba tu jest wywolanie  od przerwania  ????

run02:
	mov	a,impulse				;? sind Drehimpulse angefallen
	jz	run1                    ;0 keine Auswertung	  SWJ jezeli ni 
	call	DrehgeberAuswertung	;1 Impulse auswerten  SWJ jezlei  impuls  to do OBSLUGI IMPULSATORA

run1:
	call	tastestatus			;? wurde eine Taste gedrueckt

;===================================== swj pomijanie klawiszy  w trybie NADAWANIA

	JB	BNoLock,TasteStartRUN	; Jezelni NIE nadawanie  czyta klawiature

	LJMP	TasteRunEnd 		;jezeli aktywne nadawanie ... pomija klawisze- idzie do TasteRunEnd


;swj   menu klawiszy ====================================
$include (tasterun.inc)
;swj   menu klawiszy ====================================
	
	
run80:
	JNB	BMesssender,run800
	jmp	run99
run800:
	jnb	BFSK,run801		;? FSK aktiv
	jb	Strichpaddel,run803	;1 ? Strichpaddel aktiv = Sender ein
	Call	SendertastungEin	;  1 Sender einschalten
	jmp	Run99
run803:
	call	SendertastungAus
	jmp	run99
run801:
	jb	BKeyer,Run81		;? Keyer aktiv
	jnb	Punktpaddel,Run821      ;0 ? Taste gedrueckt
	jnb	Strichpaddel,Run821
	sjmp	Run82	                    
run821:
	call	SendertastungEin	;  1 ja
	sjmp	run85
run82:	
	Call	SendertastungAus	;  0 Sendertastung ausschalten
	sjmp	Run85
run81:
	call	IsPaddelgedrueckt	;1 Keyer ist aktiv
	jnb	BPunkt,Run83		;  ? War Punktpaddel gedrueckt
	call	SendertastungEin	;  1 Punkt ausgeben
	clr	BSpeicher
	call	Punkt
	call	SendertastungAus
	call	Punkt
	mov	TimerLock,TLock		;    2 Sek Lock eingeschalten lassen
	mov	TimerSenderAus,TSenderAus;   1 Sek Sender verzoegert ausschalten
	setb	tr0			;    Timer starten
	setb	tr1
	clr	BPunkt
Run83:
	call	IsPaddelgedrueckt	
	jnb	BStrich,Run85           ;  ? War Strichpaddel gedrueckt
	call	SendertastungEin	;  1 Strich ausgeben
	clr	BSpeicher
	mov	a,Punktspeicher
	cjne	a,#4,Run831		;    ? Punktspeicher 4 aktiv
	setb	BSpeicher               ;    1 Speichermoeglichkeit ein
Run831:
	call	Punkt
	cjne	a,#3,Run832		;    ? Punktspeicher 3 aktiv
	setb	BSpeicher		;    1 Speichermoeglichkeit ein
Run832:
	call	Punkt
	cjne	a,#2,Run833		;    ? Punktspeicher 2 aktiv
	setb	BSpeicher               ;    1 Speichermoeglichkeit ein
Run833:
	call	Punkt
	cjne	a,#1,Run834		;    ? Punktspeicher 1 aktiv
	setb	BSpeicher               ;    1 Speichermoeglichkeit ein
Run834:
	call	SendertastungAus	;    Strich zuende
	call	Punkt			;    Pause ist Punktlaenge
	mov	TimerLock,TLock		;    Lock eingeschalten lassen
	mov	TimerSenderAus,TSenderAus;   Sender verzoegert ausschalten
	setb	tr0			;    Timer starten
	setb	tr1
	clr	BStrich
Run85:
run99:
	jnb	BNoLock,run100		;? Ist Locktime verstrichen
	call	Frequenzanzeige         ;1
	call	BetriebsartAnzeige	
	clr	tr0			;  alle Timer anhalten
	clr	tr1
	orl	pcon,#00000001b		;  in den Idlemodus setzen
	orl	pcon,#00100000b
run100:
	jmp	run
;---------------------------------------------------------------------------
SendertastungEin:

;swj	call	BandfreqMerken		; swj  zapisanie  f LCD onptt

	jnb	BFSK,STE2		;? FSK
	jnb	TxTastung,STE5		;1 ? Tastung ein
	clr	TxTastung		;  1 Tastung ein                                 
	clr	SenderAus		;    auf Senden schalten                                 
	clr	BNoLock	 		;    Lock ein                                 
	call	BCDToDDS		;    Frequenz umschalten auf Senden                                 
STE5:
	jb	Punktpaddel,STE3	;  ? Shiftpotential angelegt 
	jb	BFSKShift,STE1		;  1 ? war schon Shift
	mov	Tonhoehe,#5
	jb	Brevers,STE6
	mov	Tonhoehe,#3
STE6:
	setb	BFSKShift		;    0 setzen und DDS neu laden
	sjmp	ste4
STE3:
	jnb	BFSKShift,STE1		;  0 ? war kein Shiftpot. angelegt
	mov	Tonhoehe,#3
	jb	Brevers,STE8
	mov	Tonhoehe,#5
STE8:
	clr	BFSKShift		;    0 loeschen und DDS neu laden
	sjmp	STE4
STE2:
	jnb	TxTastung,STE1		;0 ? Tastung schon ein
STE4:
	clr	TxTastung		;  1 CW ein                                 
	clr	SenderAus		;    auf Senden schalten                                 
	clr	BNoLock	 		;    Lock ein                                 
	call	BCDToDDS		;    Frequenz umschalten auf Senden                                 
STE1:
	mov	TimerLock,TLock 	;  Lock eingeschalten lassen                                 
	mov	TimerSenderAus,TSenderAus ;Sender verzoegert ausschalten                                 
	setb	tr0			;  Timer 0 starten                                 
	setb	tr1			;  Timer 1 starten                                 
	setb	BTonEin			;  Mithoerton ein                                 
	ret

;---------------------------------------------------------------------------

SendertastungAus:
	setb	TxTastung		;Sendertastung ausschalten
	call	BCDToDDS                ;Frequenz umschalten auf Empfang
	clr	BTonein
	ret
;===========================================================================
;Funktion	Abfrage ob Keyerpaddel gedrueckt ist
;Ausgang	Bit Punkt Strich gesetzt

IsPaddelgedrueckt:
	jb	Punktpaddel,IPG1	;? Punktpaddel gedrueckt
	setb	BPunkt			;1 merken
IPG1:
	jb	Strichpaddel,IPG2	;? Strichpaddel gedrueckt
	setb	BStrich			;1 merken
IPG2:
    	ret
;---------------------------------------------------------------------------
;Funktion	Zeit fuer eine Punktlaenge
;		verstreichen lassen

Punkt:
	anl	Virtuell_ien0,#11111011b;ext. Interrupt 1 sperren
	mov	r2,Geschw		;da Keyer darueber mit laeuft
Pu1:                                    ;Beeinflussung der Zeit !!!
	jnb	BSpeicher,Pu2		;? Punkt-Speicherbetrieb                           
	call	IsPaddelgedrueckt	;1 Abfrage Keyer im Punktspeicherbetr.
Pu2:
	mov	r3,#0ffh
	djnz	r3,$
	djnz	r2,Pu1
	orl	Virtuell_ien0,#00000100b;ext. Interrupt 1 freigeben
	ret

;===========================================================================
;Konstanden



DrehgeberDir	BIT	Port3.4	;Drehrichtung bei 0 = links herum	IMPULSATOR KIERUNEK
TonAusgabe	bit	Port0.7	;Ausgabe von Quittungstoenen


; przypisanie pinow od RSa do funkcji RIT i nastepne pasmo
RITpin	BIT	port3.0
PASMOUPpin	BIT	port3.1


;Festlegen des Ports und der Bits fuer den DDS-IC

DDSPort		equ	Port3

FQ_UD		bit	DDSPort.5
SClk		bit	DDSPort.6
SData		bit	DDSPort.7

Modulport	equ	Port0			;port BAND MODE TX TON  / 4 2 1 1
Modulmaske	equ	00111111b
Bandmaske	equ	00001111b
Modemaske	equ	00110000b		;maska trybow MODE

Punktpaddel	BIT	Port2.2
Strichpaddel	bit	Port2.3
TXTastung	bit	Port0.6
SenderAus	bit	Port1.3

;===========================================================================
;EEPromadressen

EEFrequenzlaenge	equ	9	;Laenge einer Frequenz

EEUp1			equ	02h	;ZF-Ablage Einzelbits
EEUp2			equ	03h     ;ZF-Ablage Einzelbits
EEStep			equ	04h     ;Schrittgroesse bei Frequenzabst.
EEPS			equ	06h	;P Punktspeicher
EEBArt			equ	07h	;A Betriebsart
					;Bit 7 BKeyer
					;Bit 6 BZFAblagePerm

EEGeschw		equ	08h	;K Geschwindigkeit Keyer
EETSenderAus		equ	09h	;S
EETLock			equ	0ah     ;L
EEZF			equ	0bh	;Z ZfCW Laenge 4 Byte
EEZFLSB			equ	0fh	;z ZfLSB Laenge 4 Byte
EEZFUSB			equ	13h	;Z ZfUSB Laenge 4 Byte
EEBandFreq 		equ	20h    	;Beginn der Bandfrequenzspeicher
					;11 x 9 Byte
EE160			equ	083h	;Begin Quick 160m
EE80			equ	EE160 + 92
EE40			equ	EE80 + 92
EE30			equ	EE40 + 92
EE20			equ	EE30 + 92
EE17			equ	EE20 + 92
EE15			equ	EE17 + 92
EE12			equ	EE15 + 92
EE10			equ	EE12 + 92
EE10_6			equ	EE10 + 92
EE10_2			equ	EE10_6 + 92



;    0123456789ABCDEF
;000 IIUUs PAKSLZZZZz 
;010 zzzZZZZ    
;020 BBBBBBBBBbbbbbbb
;030 bbBBBBBBBBBbbbbb
;040 bbbbBBBBBBBBBbbb 
;050 bbbbbbBBBBBBBBBb
;060 bbbbbbbbBBBBBBBB
;070 B              P


EEband	EQU	07ffh		;ostatnia komorka pamieci dla PASMA
;*************** zdz ************* 




;===========================================================================
;Funktion	Interruptbehandlung fuer den Drehgeber
;		erkennen der Drehrichtung und inc oder dec

intExt0:
	jnb	DrehgeberDir,_intext21	;Drehrichtung bestimmen
	inc	impulse			;rechts herum
	sjmp	_intext22
_intext21:
	dec	impulse			;links herum
_intext22:
	reti
;---------------------------------------------------------------------------
intExt1:
	reti				;leere Funktion um Idle zu verlassen

;---------------------------------------------------------------------------
;Funktion	Timer0 Laden

Timer0Laden:
	mov	th0,#0d8h	;Zeit fuer 10 mSek
	mov	tl0,#0f0h
	ret
;---------------------------------------------------------------------------
;Funktion	Interruptbehandlung fuer den Timer0

intTimer0:
	push	acc
	call	Timer0Laden	
	mov	a,TimerLock
	jz	it01
	dec	TimerLock
it01:
	mov	a,TimerSenderAus
	jz	it02
	dec	TimerSenderAus
it02:
	pop	acc
	reti
;---------------------------------------------------------------------------
;Funktion	Hier werden alle zeitunkrittischen Funktionen ausgefuehrt

Idle:
	mov	a,Modulport    		;? Mode geaendert
	anl	a,#Modemaske
	cjne	a,Betriebsart,id25
	sjmp	id26			;0
id25:
	setb	BZFneuLesen		;1 Vorbereiten zum Lesen der neuen ZF
	MOV	Betriebsart,A		;  Mode speichern  zapisanie trybu MHz LSB USB CW
	call	BCDToDDSNeu		;  eventuell neue Frequenz errechnen
id26:
	jnb	BBandumsch,id12		;? Bandumschaltung aktiv
	jmp	id221			;0
id12:
	mov	a,Modulport   		;  Abfrage des Bandmoduls
	anl	a,#Bandmaske		;  alle Ueberfluessigen Bits loeschen
	cjne	a,Band,id11		;  ? Band Uebereinstimmung 
	sjmp	id221			; 
id11:
	cjne	a,#Bandmaske,id2	;  0 ? Alle Bits gesetzt
	call	LCDDisplayclear         ;    1 Display loeschen
id1:
	mov	a,Modulport		;      Schleife
	anl	a,#Bandmaske		;        ? neue Abfrage Band ungl. 1111
	cjne	a,#Bandmaske,id2	;        1 Ende der Schleife
	
;                      XXXXXXXXXXXXXXXX	
	%WriteStrXY(1,1,' ZALOZ  ZWORKI  ')
	%WriteStrXY(1,2,'  ZMIANY PASM   ')

	
	sjmp	id1
	
id2:	           			;      Ende
	call	LCDDisplayclear	;add by swj

	mov	r7,#0
id21:
	mov	r6,#0			;    Zeit verstreichen lassen
	djnz	r6,$
	djnz	r7,id21

	mov	a,Modulport
	anl	a,#Bandmaske
	cjne	a,Band,id22		;    ? Band Uebereinstimmung
	sjmp	id221
id22:
	call	BandfreqMerken		;    0 Umschalten
	mov	Band,a
	
	
	call	Bandumschalten
id222:
	call	BCDToDDSNeu
	call	LCDDisplayclear
	call	Frequenzanzeige
	call	BetriebsartAnzeige	
id221:
	mov	a,#15 + 40h		; 
	call	LCDPos
	mov	a,#' '
	jb	BNoLock,id23		;? Lock ein
	mov	a,#'B'                  ;1 Lock anzeigen  xxxx Blokowanie strojenia
id23:                                   
	call	LCDChar
	mov	a,#14 + 40h		                  
	call	LCDPos
	mov	a,#' '
	jb	SenderAus,id24		;? Senden
	mov	a,#'N'                  ;1 Senden anzeigen  xxxx  Nadawanie zalaczone
id24:                                    
	jmp	LCDChar			;RET sparen

;---------------------------------------------------------------------------
;Zeitkonstanden
T400Hz:		db	0fbh,01dh
T500Hz:		db	0fch,017h
T600Hz:		db	0fch,0beh
T700Hz:		db	0fdh,035h
T800Hz:		db	0fdh,08eh
T900Hz:		db	0fdh,0d4h
T1000Hz:	db	0feh,006h

Timer1Laden:
	push	dph		;Register merken
	push	dpl
	push	acc
	mov	a,Tonhoehe
	cjne	a,#0,TL11 	;? Tonhoehe 400Hz
	mov	dptr,#T400Hz	;ja
	sjmp	TL18
TL11:
	cjne	a,#1,TL12
	mov	dptr,#T500Hz	;500Hz
	sjmp	TL18
TL12:
	cjne	a,#2,TL13
	mov	dptr,#T600Hz	;600Hz
	sjmp	TL18
TL13:
	cjne	a,#3,TL14
	mov	dptr,#T700Hz	;700Hz
	sjmp	TL18
TL14:
	cjne	a,#4,TL15
	mov	dptr,#T800Hz	;800Hz
	sjmp	TL18
TL15:
	cjne	a,#5,TL16
	mov	dptr,#T900Hz	;900Hz
	sjmp	TL18
TL16:
	cjne	a,#6,TL17
	mov	dptr,#T1000Hz	;1000Hz
	sjmp	TL18
TL17:
TL18:
	clr	a		;
	movc	a,@a+dptr	;Daten aus dem Code holen
	mov	th1,a		;erstes Byte laden
	mov	a,#1
	movc	a,@a+dptr	;Daten aus dem Code holen
	mov	tl1,a		;zweites Byte laden
	pop	acc		;Register restaurieren
	pop	dpl
	pop	dph
	ret
;--------------------------------------------------------------------------

;Funktion	Interruptbehandlung fuer den Timer1
intTimer1:
	push	acc
	call	Timer1Laden	;Timerregister wieder laden
	jnb	BTonEin,IT11	;? Tonausgabe ein
	cpl	TonAusgabe	;1 Ton erzeugen
	sjmp	IT12
IT11:
	setb	Tonausgabe	;0 Ausgang definiert setzen
	clr	tr1		;  Timer erst sperren wenn Ausgang definiert
IT12:				;  gesetzt
	pop	acc
	reti

;==========================================================================
;Funktion	Nur jeder 4. Impuls wird gezaehlt
;Input		gezaehlte Impulse ueber Interrupt in "Impulse"
;Output		durch 4 geteilte Impulse in Register A

DrehimpulseGrob:
	mov	a,impulse		;Impulse holen
	jb	acc.7,DI1		;? Drehrichtung links herum
	rr	a			;nein /2 teilen
	rr	a			;/2 teilen	
	anl	a,#00111111b	;nur die untersten 6 Bit auswerten
	clr	c			;rechts herum
	sjmp	DI2			;ende
DI1:
	cpl	a			;Impulse negieren
	inc	a			;+ 1
	rr	a			;/4
	rr	a
	anl	a,#00111111b	;nur untersten 6 Bit
	setb	c			;Drehrichtung war links herum
DI2:
	ret
;--------------------------------------------------------------------------
;================================  stepswj

$include (stepgs.inc)

;xxxxx 

;---------------------------------------------------------------------------

BehandlungTaste2M:
	call	LCDDisplayClear			;LCD loeschen
	%WriteStrXY(1,1,'Wobulowanie B->A')
	%WriteStrXY(1,2,'Stop = anykey')
	call	TasteInput			;warten bis Taste UP
	call	TestAgroesserB			;? Frqu A < B
	jnc	BT2M2				;
	mov	r0,#BCDFrequenzA		;1 Frequenzen tauschen
	mov	r1,#BCDZf
	call	RamToRamL4
	mov	r0,#BCDFrequenzB
	mov	r1,#BCDFrequenzA
	call	RamToRamL4
	mov	r0,#BCDZf
	mov	r1,#BCDFrequenzB
	call	RamToRamL4
BT2M2:	
	mov	r0,#BCDFrequenzB		;Startfrequenz merken
	mov	r1,#BCDZf
	call	RamToRamL4
	clr     Punktpaddel
	clr	Strichpaddel
	call	BFrequenzNachladen
	setb    Punktpaddel
	setb	Strichpaddel
	clr	BIsFrqA				;B Frequenz aktivieren
	call	BCDToDDSNeu                     ;Frequenz ausgeben
	call	WAnzeige
BT2M1:                     			;Schleife
	mov	r0,#BCDFrequenzB + 3		;  Step addieren
	mov	r1,#temp + 7
   	call	ADD_BCD
	call	BCDToDDSNeu			;  Frequenz ausgeben
	call	TestAgroesserB			;  ? A > B
	jnc	BT2M3
	call	WAnzeige
	clr     Punktpaddel
	clr	Strichpaddel
	call	BFrequenzNachladen
	setb    Punktpaddel
	setb	Strichpaddel
BT2M3:
	call	TasteStatus			;Ende durch tastendruck
	jnc	BT2M1
	call	TasteInput			;warten bis Taste UP
	call	BFrequenzNachladen
	call	LCDDisplayClear			;LCD loeschen
	call	EEZfLesen			;ZF neu aus Eeprom lesen
	mov	impulse,#0
	ret

TestAgroesserB:
	mov	r7,#4 
	mov	r0,#BCDFrequenzA + 3
	mov	r1,#BCDFrequenzB + 3
	clr	c
TAB1:
	mov	a,@r0
	subb	a,@r1
	dec	r0
	dec	r1
	djnz	r7,TAB1				;B > A C = 1
	ret					;A > B C = 0

WAnzeige:
	cpl	BWobbeln
	jb	BWobbeln,WAN1
	%WriteStrXY(15,2,'X')
	sjmp	WAN2
WAN1:
	%WriteStrXY(15,2,'O')
WAN2:
    	ret

BFrequenzNachladen:
	mov	r0,#BCDZf			;  1 B Frequenz nachladen
	mov	r1,#BCDFrequenzB
	call	RamToRamL4
	ret

;---------------------------------------------------------------------------
BehandlungTaste3M:
	mov	temp+8,#0			;
	mov	temp+9,#0
	mov	temp+10,#0
	mov	temp+11,#0
	call	LCDDisplayClear
	%WriteStrXY(1,1,'Skok wobulowania')
	%WriteStrXY(10,2,'Hz')

	call	LCDWStep
	call	TasteInput			;warten bis Taste UP
BHT3M2:
	mov 	a,impulse
	jz	BHT3M1
	push	acc
	mov 	impulse,#0
	mov	temp+11,#1
	mov	temp+10,#0
	call	TasteStatus
	cjne	a,#1,BHT3M4
	mov	temp+11,#10H
	mov	temp+10,#0
BHT3M4:	
	cjne	a,#2,BHT3M5
	mov	temp+11,#0
	mov	temp+10,#1H
BHT3M5:	
	mov	r0,#temp+7
	mov	r1,#temp+11
	pop	acc
	jb	acc.7,BHT3M3		;    ? Drehrichtung recht herum                                                                      
	call	ADD_BCD
	sjmp	BHT3M1
BHT3M3:
	call	SUBB_BCD
BHT3M1:
	call	LCDWStep
	call	TasteStatus
	cjne	a,#4,BHT3M2
	mov	impulse,#0
	jmp	TasteInput		;RET sparen

LCDWstep:
	mov	a,#40h
	call	LCDPos
	mov	r7,#4
	mov	r0,#Temp + 4
LCDW1:
	mov	a,@r0
	call	LCDOutByte
	inc	r0
	djnz	r7,LCDW1
	ret

;---------------------------------------------------------------------------
MT1Min	equ	0
MT1Max	equ	24		;24 Menupunkte

;verschiedene Anzeigen

T11:
;                      XXXXXXXXXXXXXXXX
	%WriteStrXY(1,1,'  KONFIGURACJA  ')
	ret
T12:
;                      XXXXXXXXXXXXXXXX
	%WriteStrXY(1,1,'  ZMIANA PASMA  ')
	ret

T13:
;                      XXXXXXXXXXXXXXXX
	%WriteStrXY(1,1,'<<    MENU    >>')
	ret

T14:
;                      XXXXXXXXXXXXXXXX
	%WriteStrXY(1,1,'    FUNKCJA     ')
	ret

T15:
;                      XXXXXXXXXXXXXXXX
	%WriteStrXY(1,1,'   USTAWIENIE   ')
	ret



;Funktion	Anzeige der Einstellmoeglichkeiten im Tastendruck Taste 2
;Input		Taste2 ist gedrueckt, Drehgeber wird gedreht
;Output	wird eine neue Einstellung gewhlt, so wird sie abgespeichert
;		wird nur die Taste gedrueckt wird auf Schnellabstimmung geschaltet



BehandlungTaste1:
	clr	BMenu		;Drehgeber noch nicht betaetigt
	call	LCDDisplayClear	;Anzeige alles loeschen




BT10:


	MOV	A,MenuTaste1	;ladowanie ostatnio uzywanej pozycji MENU
	cjne	a,#0,BT1101
	call	T11
	%WriteStrXY(1,2,'Posredniej CW')
BT1101:
	cjne	a,#1,BT11011
	call	T11
	%WriteStrXY(1,2,'Posredniej LSB')
BT11011:
	cjne	a,#2,BT11012
	call	T11
;                      XXXXXXXXXXXXXXXX	
	%WriteStrXY(1,2,'Posredniej USB')
BT11012:
	cjne	a,#3,BT11010
	call	T11
;                      XXXXXXXXXXXXXXXX
	%WriteStrXY(1,2,'Tryb posredniej')
BT11010:
	cjne	a,#4,BT1102
	call	T11
;                      XXXXXXXXXXXXXXXX
	%WriteStrXY(1,2,'Czasu Blokowania')
BT1102:
	cjne	a,#5,BT1103
	call	T11
;                      XXXXXXXXXXXXXXXX
	%WriteStrXY(1,2,'Czasu podt. nad.')
BT1103:
	cjne	a,#6,BT1104
	call	T15
	%WriteStrXY(1,2,'Tempa Klucza')
BT1104:
	cjne	a,#7,BT1105
	call	T14
	%WriteStrXY(1,2,'Klucz CW')
	jb	Bkeyer,BT11041
	%WriteStrXY(11,2,'zalacz')
	sjmp	BT1105
BT11041:
	%WriteStrXY(11,2,'wylacz')
BT1105:
	cjne	a,#8,BT1107
	call	T15
	%WriteStrXY(1,2,'Pamieci kropki')
BT1107:
	cjne	a,#9,BT1108
	call	T11
	%WriteStrXY(1,2,'Nad.')
	jb	BZFAblagePerm,BT11071
	%WriteStrXY(5,2,'CW z posr.')
	sjmp	BT1108
BT11071:
	%WriteStrXY(5,2,'CW bez posr.')
BT1108:
	cjne	a,#10,BT1109
	call	T11
	%WriteStrXY(1,2,'Granice PASM')
	jb	BBandgrenzen,BT11091
	%WriteStrXY(14,2,'zal')
	sjmp	BT1109
BT11091:
	%WriteStrXY(14,2,'wyl')
BT1109:
	cjne	a,#11,BT1110
	call	T15
	%WriteStrXY(1,2,'Tryb FSK')
	jb	BFSK,BT11111
	%WriteStrXY(10,2,'zalacz')
	sjmp	BT1110
BT11111:
	%WriteStrXY(10,2,'wylacz')
BT1110:
	cjne	a,#12,BT1111

;                      XXXXXXXXXXXXXXXX
	%WriteStrXY(1,1,'PRZELACZNIK PASM')

	jb	BBandumsch,BT11121
;                      XXXXXXXXXXXXXXXX
	%WriteStrXY(1,2,'   Sterowanie   ')
	orl	ModulPort,#00001111b
	sjmp	BT1111
BT11121:
;                      XXXXXXXXXXXXXXXX
	%WriteStrXY(1,2,'     Odczyt    ')
BT1111:
	cjne	a,#13,BT1112
	call	T12
	%WriteStrXY(1,2,'160m  1,8 MHz')
BT1112:
	cjne	a,#14,BT1113
	call	T12
	%WriteStrXY(1,2,' 80m  3,5 MHz')
BT1113:
	cjne	a,#15,BT1114
	call	T12
	%WriteStrXY(1,2,' 40m    7 MHz')
BT1114:
	cjne	a,#16,BT1115
	call	T12
	%WriteStrXY(1,2,' 30m  10,5 MHz')
BT1115:
	cjne	a,#17,BT1116
	call	T12
	%WriteStrXY(1,2,' 20m  14 MHz')
BT1116:
	cjne	a,#18,BT1117
	call	T12
	%WriteStrXY(1,2,' 17m  18 MHz')
BT1117:
	cjne	a,#19,BT1118
	call	T12
	%WriteStrXY(1,2,' 15m  21 MHz')
BT1118:
	cjne	a,#20,BT1119
	call	T12
	%WriteStrXY(1,2,' 12m  24 MHz')
BT1119:
	cjne	a,#21,BT11201
	call	T12
	%WriteStrXY(1,2,' 10m  28 MHz')
BT11201:
	cjne	a,#22,BT11202
	call	T12
	%WriteStrXY(1,2,'Trsv 6m 50 MHz')
BT11202:
	cjne	a,#23,BT11203
	call	T12
;                      XXXXXXXXXXXXXXXX	
	%WriteStrXY(1,2,'Trsv 2m 144 MHz')
BT11203:
	cjne	a,#24,BT1121
	call	T13
;                      XXXXXXXXXXXXXXXX	
	%WriteStrXY(1,2,'    WYJSCIE     ')

BT1121:
	call	DrehimpulseGrob		;? Impulse A=0 nein  A!=0 ja
	jz	BT151			;nein
	setb	BMenu			;Drehgeber wurde betaetigt
	mov	Impulse,#0		;zuruecksetzen der Impulse
	jc	BT16			;? Drehrichtung rechts
	inc	MenuTaste1		;nein Menupunkt + 1
	mov	a,MenuTaste1		;? Menuende erreicht
	JB	BBandumsch,BT1122       ;? Bandumschaltung aktiv - czy zmiana pasma aktywna ??

; jezeli odczyt pasm to program idzie dalej do menu 24 
	CJNE    A,#13,BT1122            ;0 Bandumsch. ueberspringen  - przeskok dalej
	mov	a,#24                   ;  neuer Menuepunkt
	mov	MenuTaste1,a            ;  merken

BT1122:

	
	cjne	a,#MT1Max+1,BT17
	mov	MenuTaste1,#0		;ja wieder zum Anfang des Menus
BT17:					;nein
	sjmp	BT15
BT16:
	dec	MenuTaste1		;Menupunkt - 1
	mov	a,MenuTaste1		;
	jb	BBandumsch,BT161        ;? Bandumschaltung aktiv
	cjne    a,#23,BT161             ;0 Bandumsch. ueberspringen
	mov	a,#12                   ;  neuer Menuepunkt
	mov	MenuTaste1,a            ;  merken
BT161:
	cjne    a,#MT1Min-1,BT15
	mov	MenuTaste1,#MT1Max	;ja wieder zum Ende des Menus
BT15:
	call	LCDDisplayClear
BT151:
	call	Tastestatus		;? Taste noch gedrueckt
	jnc	BT18			;
	jmp	BT10			;1 wieder von vorn
BT18:
	jb	BMenu,BT181		;0 ? neue Menueinstellung
BT181:
	mov	a,MenuTaste1		;  neue Menueinstellung
	cjne	a,#0,BT190
	mov	dptr,#EEZF
	mov	r0,#TEMP		;  ZF fuer CW
	call	EepromReadL4
	call	ZFEinstellen
	mov	dptr,#EEZF		;  fertig
	mov	r0,#Temp
	call	EEPromWriteL4		;  und im EEprom speichern
	jmp	BT199
BT190:
	cjne	a,#1,BT1902
	mov	dptr,#EEZFLSB
	mov	r0,#TEMP		;  ZF fuer LSB
	call	EepromReadL4
	call	ZFEinstellen
	mov	dptr,#EEZFLSB		;  fertig
	mov	r0,#Temp
	call	EEPromWriteL4		;  und im EEprom speichern
	jmp	BT199
BT1902:
	cjne	a,#2,BT1903
	mov	dptr,#EEZFUSB
	mov	r0,#TEMP		;  ZF fuer USB
	call	EepromReadL4
	call	ZFEinstellen
	mov	dptr,#EEZFUSB		;  fertig
	mov	r0,#Temp
	call	EEPromWriteL4		;  und im EEprom speichern
	jmp	BT199
BT1903:
	cjne	a,#3,BT1901
	call	ZFAblage
	jmp	BT199
BT1901:
	cjne	a,#4,BT191
	mov	a,TLock
	call	TimerEinstellen
	mov	TLock,a
	call	EETLockWrite
	jmp	BT199
BT191:
	cjne	a,#5,BT192
	mov	a,TSenderAus
	call	TimerEinstellen
	mov	TSenderAus,a
   	call	EETSenderAusWrite
	jmp	BT199
BT192:
	cjne	a,#6,BT193
	mov	a,Geschw
	cpl	a
	call	GeschwEinstellen
	cpl	a
	mov	Geschw,a
   	call	EEGeschwWrite
	jmp	BT199
BT193:
	cjne	a,#7,BT194
	cpl	BKeyer
	mov	dptr,#EEBArt
	call	EERead
	mov	c,BKeyer
	mov	acc.7,c
	mov	dptr,#EEBArt
	call	EEWrite	
	jmp	BT199
BT194:
	cjne	a,#8,BT195
	mov	a,Punktspeicher
	call	PunktSpEingabe
	mov	Punktspeicher,a
	mov	dptr,#EEPS
	call	EEWrite	
	jmp	BT199
BT195:
	cjne	a,#9,BT196
	cpl	BZFAblagePerm
	mov	dptr,#EEBArt
	call	EERead
	mov	c,BZFAblagePerm
	mov	acc.6,c
	mov	dptr,#EEBArt
	call	EEWrite	
	jmp	BT199
BT196:
	cjne	a,#10,BT197
	cpl	BBandgrenzen
	mov	dptr,#EEBArt
	call	EERead
	mov	c,BBandgrenzen
	mov	acc.5,c
	mov	dptr,#EEBArt
	call	EEWrite	
	jmp	BT199
BT197:
	cjne	a,#11,BT198
	cpl	BFSK
	jb	BFSK,BT1971             ;? FSK aktiv
	call	EEReadBKeyer		;0 Keyerzustand lesen
	mov	tonhoehe,#3
	sjmp	BT1972			
BT1971:
	clr	BKeyer			;1 Keyer aus
BT1972:
	call	EEZFLesen		;Falls LSB,USB bei FSK ZF CW einst.
	jmp	BT199
BT198:
	cjne	a,#12,BT19801
	cpl	BBandumsch
	mov	dptr,#EEBArt
	call	EERead
	mov	c,BBandumsch
	mov	acc.4,c
	mov	dptr,#EEBArt
	call	EEWrite	
	JB	BBandumsch,BT19803      ;? Bandumschaltung aktiv - zmiana pasm z MENU
	ORL	ModulPort,#00001111b    ;0 Einlesen aktivieren  - odczyt pasm aktywny
	
BT19803:	
	sjmp	BT199                   ;  Break zum Ende
BT19801:
	cjne	a,#24,BT19802           ;Abbruch
	sjmp	BT199			
BT19802:
	push	acc
	call	BandfreqMerken		;1 Umschalten des Bandes - Zmiana pasma
	pop	acc
	clr	c
	subb	a,#13			;  Shift 13 subtrahieren
	mov	Band,a			;  merken
	
; ******************** zdz ********************
	MOV DPTR,#EEband		
	call EEwrite		; zapis pasma do epromu zmiana z MENU
; ******************** zdz ******************** 

	call	Bandumschalten		;  umschalten
BT199:
	SETB	BZFneuLesen		;eventuelle Aenderung aktivieren -possible change activate
	JMP	MenuEndeBehandlung	;gemeinsame Behandlung beim beenden - common treatment with terminate

;--------------------------------------------------------------------------
ZFStelle	equ	temp + 4	;Speicher fuer Kursor ZF Aenderung

ZFEinstellen:
	mov	ZFstelle,#40h		;Kursor auf Hoechste Stelle
	call	LCDDisplayClear		;Anzeige neu Aufbauen
ZFE01:
	mov	a,#4ah
	call	LCDPos
	mov	a,#0
	call	LCDChar
	inc	a
	call	LCDChar
	inc	a
	call	LCDChar
	inc	a
	call	LCDChar
	mov	a,ZFStelle
	call	LCDPos
	mov	a,#'#'			;Kursor zeigen
	call	LCDChar
	mov	a,#0
	call	LCDPos
	mov	r0,#Temp		;ZF auf LCD
	mov	r7,#4
ZFE1:
	mov	a,@r0
	call	LCDOutByte
	inc	r0
	djnz	r7,ZFE1

	call	TasteStatus		;? Taste gedrueck
	jnc	ZFE6			;nein
	call	TasteInput		;ja
	cjne	a,#1,ZFE2		;? Taste 1
	dec	ZFStelle		;ja Kursor eins nach links
	mov	a,ZFStelle
	cjne	a,#03fh,ZFE2		;? absolut linke Position erreicht
	mov	ZFStelle,#47H		;ja rechts wieder anfangen
ZFE2:
	cjne	a,#2,ZFE3		;? Taste 2
	inc	ZFStelle		;ja Kursor eins nach rechts
	mov	a,ZFStelle
	cjne	a,#48h,ZFE3		;? absolut rechte Position erreicht
	mov	ZFStelle,#40h		;ja links wieder anfangen
ZFE3:
	cjne	a,#3,ZFE4		;? Taste 3
        pop    acc        ; zdz zdjcie ze stosu adresu powrotu ZFEinstellen:
        pop    acc        ; i skoczenie do BT199
        jmp    BT199        ; moe wystarczy tylko 'pop a'

ZFE4:
	cjne	a,#4,ZFE5		;? Taste 4
	sjmp	ZFE100                  ;Zum Ende der Funktion
ZFE5:
	call	LCDDisplayClear		;Taste war gedrueckt LCD loeschen
ZFE6:
	call	DrehImpulseGrob		;? Sind min 4 Drehimpulse angefallen
	jz	ZFE99			;nein
	jc	ZFE63			;ja ? links herum gedreht
	call	LCDDisplayClear		;   nein
	mov	a,ZFStelle		;? welches Nibbel wird geaendert
	rrc	a                       ;
	jnc	ZFE62			;das untere Nibbel
	anl	a,#1fh
	add	a,#Temp
	mov	r0,a
	inc	@r0			;unteres Nibbel um 1 erhoehen
	mov	a,@r0
	anl	a,#0fh
	cjne	a,#0ah,ZFE64		;? > 9
	mov	a,@r0			;ja =0 wieder von vorn
	anl	a,#0f0h
	mov	@r0,a
ZFE64:
	sjmp	ZFE63
ZFE62:
	anl	a,#1fh			;das obere Nibbel
	add	a,#Temp			;Stelle ermitteln
	mov	r0,a
	mov	a,@r0
	add	a,#10h			;oberes Nibbel um 1 erhoehen
	mov	@r0,a
	anl	a,#0f0h
	cjne	a,#0a0h,ZFE63		;? Bereich ueberschritten
	mov	a,@r0			;ja wieder mit 0 beginnen
	anl	a,#0fh
	mov	@r0,a
ZFE63:	
	mov	impulse,#0		;Drehimpulse loeschen
ZFE61:	
ZFE99:
	jmp	ZFE01			;wieder von vorn beginnen
ZFE100:
	ret				;Ende der Funktion

;--------------------------------------------------------------------------
ZFAblage:
	mov	ZFstelle,#40h		;Kursor auf Hoechste Stelle
	call	LCDDisplayClear
	mov	dptr,#EEUp1
	call	EERead
	mov	Temp,a
	inc	dptr
	call	EERead
	mov	Temp + 1,a
ZFA1:
	mov	a,#4ah
	call	LCDPos
	mov	a,#0
	call	LCDChar
	inc	a
	call	LCDChar
	mov	a,#4
	call	LCDChar
	mov	a,#3
	call	LCDChar
	mov	a,#0
	call	LCDPos
	mov	a,Temp
	mov	c,acc.7
	call	LCDCBit
	mov	c,acc.6
	call	LCDCBit
	mov	c,acc.5
	call	LCDCBit
	mov	c,acc.4
	call	LCDCBit
	mov	c,acc.3
	call	LCDCBit
	mov	c,acc.2
	call	LCDCBit
	mov	c,acc.1
	call	LCDCBit
	mov	c,acc.0
	call	LCDCBit
	mov	a,temp + 1
	mov	c,acc.7
	call	LCDCBit
	mov	a,ZFStelle
	call	LCDPos
	mov	a,#'#'
	call	LCDChar

	call	TasteStatus		;? Taste gedrueck
	jc	ZFA101
	jmp	ZFA6
ZFA101:					;nein
	call	TasteInput		;ja
	cjne	a,#1,ZFA2		;? Taste 1
	dec	ZFStelle		;ja Kursor eins nach links
	mov	a,ZFStelle
	cjne	a,#03fh,ZFA2		;? absolut linke Position erreicht
	mov	ZFStelle,#48H		;ja rechts wieder anfangen
ZFA2:
	cjne	a,#2,ZFA3		;? Taste 2
	inc	ZFStelle		;ja Kursor eins nach rechts
	mov	a,ZFStelle
	cjne	a,#49h,ZFA3		;? absolut rechte Position erreicht
	mov	ZFStelle,#40h		;ja links wieder anfangen
ZFA3:
	cjne	a,#3,ZFA4		;? Taste 3
	mov	a,ZFStelle
	cjne	a,#40h,ZFA31
	mov	a,temp
	cpl	acc.7
	mov	temp,a
	jmp	ZFA5
ZFA31:
	cjne	a,#41h,ZFA32
	mov	a,temp
	cpl	acc.6
	mov	temp,a
	jmp	ZFA5
ZFA32:
	cjne	a,#42h,ZFA33
	mov	a,temp
	cpl	acc.5
	mov	temp,a
	jmp	ZFA5
ZFA33:
	cjne    a,#43h,ZFA34
	mov	a,temp
	cpl	acc.4
	mov	temp,a
	jmp	ZFA5
ZFA34:
	cjne	a,#44h,ZFA35
	mov	a,temp
	cpl	acc.3
	mov	temp,a
	jmp	ZFA5
ZFA35:
	cjne	a,#45h,ZFA36
	mov	a,temp
	cpl	acc.2
	mov	temp,a
	jmp	ZFA5
ZFA36:
	cjne	a,#46h,ZFA37
	mov	a,temp
	cpl	acc.1
	mov	temp,a
	jmp	ZFA5
ZFA37:
	cjne	a,#47h,ZFA38
	mov	a,temp
	cpl	acc.0
	mov	temp,a
	jmp	ZFA5
ZFA38:
	cjne	a,#48h,ZFA39
	mov	a,temp + 1
	cpl	acc.7
	mov	temp + 1,a
	jmp	ZFA5
ZFA39:
	sjmp	ZFA6			;ja Wechsel
ZFA4:
	cjne	a,#4,ZFA5		;? Taste 4
	mov	dptr,#EEUp1		;1
	mov	a,Temp
	call	EEWrite			;  und im EEprom speichern
	mov	dptr,#EEUp2
	mov	a,Temp + 1
	call	EEWrite			;  und im EEprom speichern
	sjmp	ZFA100
ZFA5:
	call	LCDDisplayClear		;0 Taste war gedrueckt LCD loeschen
ZFA6:
	jmp	ZFA1
ZFA7:
ZFA100:
	mov	a,Temp
	mov 	c,acc.7
	mov	BUp160m,c
	mov 	c,acc.6
	mov	BUp80m,c
	mov 	c,acc.5
	mov	BUp40m,c
	mov 	c,acc.4
	mov	BUp30m,c
	mov 	c,acc.3
	mov	BUp20m,c
	mov 	c,acc.2
	mov	BUp17m,c
	mov 	c,acc.1
	mov	BUp15m,c
	mov 	c,acc.0
	mov	BUp12m,c
	mov	a,Temp + 1
	mov 	c,acc.7
	mov	BUp10m,c
	ret

AblageSetzen:
	mov	dptr,#EEUp1
	call	EERead
	mov	Temp,a
	inc	dptr
	call	EERead
	mov	Temp + 1,a
	sjmp	ZFA100

;--------------------------------------------------------------------------
GeschwEinstellen:
	mov	Temp + 4,a
	mov	Impulse,#0
	call	LCDDisplayClear
	%WriteStrXY(1,1,'Szybk:    znakow')
	sjmp	TE1

TimerEinstellen:
	mov	Temp + 4,a
	mov	Impulse,#0
	call	LCDDisplayClear
	%WriteStrXY(1,1,'Timer:    0 mSek')
TE1:
	mov	a,#4ah
	call	LCDPos
	mov	a,#3
	call	LCDChar
	call	LCDChar
	call	LCDChar
	call	LCDChar
	mov	a,Temp + 4
	call	HexToDez
	%WriteXYOhneNull(7,1,Temp)
	call	TasteStatus
	jc	TE9
	mov	a,Impulse
	jz	TE8
	mov	b,a
	mov	a,Temp + 4
	add	a,b	
	mov	Temp + 4,a
	mov	Impulse,#0
TE8:
	sjmp	TE1
TE9:
	call	TasteStatus
	jc	TE9
	mov	a,Temp + 4
	ret

;--------------------------------------------------------------------------
PunktSpEingabe:
	mov	Temp + 4,a
	mov	Impulse,#0
	call	LCDDisplayClear
	%WriteStrXY(1,1,'Pamiec:')
PE1:
	mov	a,#4ah
	call	LCDPos
	mov	a,#3
	call	LCDChar
	call	LCDChar
	call	LCDChar
	call	LCDChar
	mov	a,Temp + 4
	call	HexToDez
	%WriteXYOhneNull(11,1,Temp)
	call	TasteStatus
	jc	PE9
	mov	a,Impulse
	jz	PE8
	jb	acc.7,PE2
	mov	a,Temp + 4
	inc	a
	cjne	a,#5,PE3
	mov	a,#0
PE3:
	sjmp	PE4
PE2:
	mov	a,temp + 4
	dec	a
	cjne	a,#0ffh,PE4
	mov	a,#4
PE4:
	mov	Temp + 4,a
	mov	Impulse,#0
PE8:
	sjmp	PE1
PE9:
	call	TasteStatus
	jc	PE9
	mov	a,Temp + 4
	ret

;--------------------------------------------------------------------------

;=========================================stepswj
$include (stepms.inc)

;---------------------------------------------------------------------------
MT3Min	equ	0
MT3Max	equ	11

T31:
	%WriteStrXY(1,1,'Zapis pamieci')
	%WriteStrXY(1,2,'Pozycja:')
	call	QuickDPTRLaden
	call	EERead			;Nr des benutzten Speicherplatzes
	inc	a			;die naechste Speicherplatznr.
	cjne	a,#0ah,T32		;? > 9
	mov	a,#0			;1 wieder von vorn
T32:
	push	acc
 	mov	a,#49h			;  xxxx byo 47h  pozycja napisu
	call	LCDPos
	pop	acc
	jmp	LCDOutByte		;RET sparen

;Funktion	Anzeige der Einstellmoeglichkeiten im Tastendruck Taste 3
;Input		Taste3 ist gedrueckt, Drehgeber wird gedreht oder nur Taste druecken
;Output		wird eine neue Einstellung gewhlt, so wird sie abgespeichert
;		Wird nur Taste gedrueckt wird die Frequenz im EEprom abgelegt
 
BehandlungTaste3:
	call	LCDDisplayClear
	mov	MenuTaste3,#0
BT30:
	mov	a,MenuTaste3
	cjne	a,#0,BT31
	call	T31
	sjmp	BT33
BT31:
	cjne	a,#11,BT32
	%WriteStrXY(1,1,'WYJSCIE')
	sjmp	BT33
BT32:
	call	QuickspeicherView
BT33:
	call	DrehimpulseGrob		;? Impulse A=0 nein  A!=0 ja
	jz	BT351			;nein
	mov	Impulse,#0		;zuruecksetzen der Impulse
	jc	BT36			;? Drehrichtung rechts
	inc	MenuTaste3		;nein Menupunkt + 1
	mov	a,MenuTaste3		;? Menuende erreicht
	cjne	a,#MT3Max+1,BT37
	mov	MenuTaste3,#0		;ja wieder zum Anfang des Menus
BT37:					;nein
	sjmp	BT35
BT36:
	dec	MenuTaste3		;Menupunkt - 1
	mov	a,MenuTaste3		;? Menuanfang erreicht
	cjne    a,#MT3Min-1,BT35
	mov	MenuTaste3,#MT3Max	;ja wieder zum Ende des Menus
BT35:
	call	LCDDisplayClear
BT351:
	call	Tastestatus		;? Taste noch gedrueckt
	jnc	BT38			;nein
	jmp	BT30			;ja wieder von vorn
BT38:
	mov	a,MenuTaste3		;Einstellung ist gueltig
	cjne	a,#0,BT320
	call	QuickspeicherSchreiben
	sjmp	BT323
BT320:
	cjne	a,#11,BT321
	sjmp	BT323
BT321:
	call	QuickspeicherLesen
BT323:
	jmp	MenuEndeBehandlung	;gemeinsame Behandlung beim beenden

;---------------------------------------------------------------------------
;Funktion	je Band entsprechenden Speicheranfang in dptr laden

QuickDPTRLaden:
	push	acc
	mov	a,Band
	cjne	a,#0,QSD1
	mov	dptr,#EE160
QSD1:
	cjne	a,#1,QSD2
	mov	dptr,#EE80
QSD2:
	cjne	a,#2,QSD3
	mov	dptr,#EE40
QSD3:
	cjne	a,#3,QSD4
	mov	dptr,#EE30
QSD4:
	cjne	a,#4,QSD5
	mov	dptr,#EE20
QSD5:
	cjne	a,#5,QSD6
	mov	dptr,#EE17
QSD6:
	cjne	a,#6,QSD7
	mov	dptr,#EE15
QSD7:
	cjne	a,#7,QSD8
	mov	dptr,#EE12
QSD8:
	cjne	a,#8,QSD9
	mov	dptr,#EE10
QSD9:
	cjne	a,#9,QSD10
	mov	dptr,#EE10_6
QSD10:
	cjne	a,#10,QSD11
	mov	dptr,#EE10_2
QSD11:
	pop	acc
	ret
;---------------------------------------------------------------------------
;Funktion	Schreiben in den Eepromspeicherplatz Quick


QuickspeicherSchreiben:
 	call	QuickDPTRLaden
	call	EERead
	inc	a		;naechste Speicherstelle im Eeprom
	cjne	a,#0ah,QSS0	;? 10
QSS0:
	jc	QSS1
	mov	a,#0		;1 wieder mit 0 beginnen
QSS1:
	call	EEWrite		;neuen Index speichern
	call	QAdresseErmitteln
	mov	r0,#BCDFrequenzA
	mov	r6,#8		;Frequenz besteht aus 8 Byte
QSS99:
	mov	a,@r0
	call	EEWrite
	inc	r0
	inc	dptr
	djnz	r6,QSS99
	ret

;---------------------------------------------------------------------------
;Funktion	Anschauen der Eepromspeicherplatz Quick

QuickSpeicherView:
	push	acc
	dec	a
	push	acc
	%WriteStrXY(13,1,'P:')
	pop	acc
	push	acc
	call	LCDOutByte
	pop	acc
 	call	QuickDPTRLaden
	call	QAdresseErmitteln
	mov	r6,#8
	mov	r0,#Temp + 4
QSV1:
	call	EERead
	mov	@r0,a
	inc	r0
	inc	dptr
	djnz	r6,QSV1
	mov	a,#2h
	call	LCDPos
	mov	r0,#Temp + 4
	call	AnzTransverter
	Call	FrequenzAnz
	mov	a,#42h
	call	LCDPos
	mov	r0,#Temp + 8
	call	AnzTransverter
	Call	FrequenzAnz
	pop	acc
	ret

;---------------------------------------------------------------------------
;Funktion	Laden der Daten aus dem Eepromspeicherplatz Quick

QuickspeicherLesen:
	dec	a
 	call	QuickDPTRLaden
	call	QAdresseErmitteln
	mov	r0,#Temp
	mov	r6,#8
QSL1:
     	call	EERead
	mov	@r0,a
	inc	r0
	inc	dptr
	djnz	r6,QSL1
	mov	r0,#Temp + 3
	jnb	BBandgrenzen,QSL2	;? Bandgrenzenkontrolle
	Call	FrequTestIncQ		;1 testen
	jc	QSLEnde
	mov	r0,#Temp + 3
	Call	FrequTestDecQ
	jc	QSLEnde
QSL2:
	mov	r0,#Temp
	mov	r1,#BCDFrequenzA
	mov	r7,#8
	call	RamToRam
	clr	BRit
QSLEnde:	
	ret

QAdresseErmitteln:
	mov	b,#9
	mul	ab
	inc	dptr
	add	a,dpl
	mov	dpl,a
	mov	a,b
	addc	a,dph
	mov	dph,a
	ret

;---------------------------------------------------------------------------
;Funktion	Anzeige der Einstellmoeglichkeiten im Tastendruck Taste 4
;Input		Taste2 ist gedrueckt, Drehgeber wird gedreht
;Output		wird eine neue Einstellung gewhlt, so wird sie abgespeichert


MT4Min	equ	0
MT4Max	equ	5

T41:
	%WriteStrXY(1,1,'Czestotliwosc:')
	ret

BehandlungTaste4m:
BehandlungTaste4:
	clr	BMenu
	call	LCDDisplayClear
BT40:
	call	T41
	jnb	BFSK,BT401
	jb	BMenu,BT401
	%WriteStrXY(1,2,'FSK odwrotne' )
	jmp	BT46
BT401:
	mov	a,MenuTaste4
	cjne	a,#0,BT41
	%WriteStrXY(1,2,'VFO  A / B' )
BT41:
	cjne	a,#1,BT42
	%WriteStrXY(1,2,'VFO  A = B')
BT42:
	cjne	a,#2,BT43
	%WriteStrXY(1,2,'Split')
BT43:
	cjne	a,#3,BT44
	%WriteStrXY(1,2,'Rit')
BT44:
	cjne	a,#4,BT45
	%WriteStrXY(1,2,'Strojenie TX')
BT45:
	cjne	a,#5,BT46
	%WriteStrXY(1,2,'Zapis VFO')
BT46:
	call	DrehimpulseGrob		;? Impulse A=0 nein  A!=0 ja
	jz	BT4151			;
	setb	BMenu			; 
	mov	Impulse,#0		;  zuruecksetzen der Impulse
	jc	BT416			;  ? Drehrichtung rechts
	inc	MenuTaste4		;  0 Menupunkt + 1
	mov	a,MenuTaste4		;    ? Menuende erreicht
	cjne	a,#MT4Max+1,BT417
	mov	MenuTaste4,#0		;    1 wieder zum Anfang des Menus
BT417:					;
	sjmp	BT415
BT416:
	dec	MenuTaste4		;  1 Menupunkt - 1
	mov	a,MenuTaste4		;    ? Menuanfang erreicht
	cjne    a,#MT4Min-1,BT415
	mov	MenuTaste4,#MT4Max	;    1 wieder zum Ende des Menus
BT415:
	call	LCDDisplayClear
BT4151:
	call	Tastestatus		;0 ? Taste noch gedrueckt
	jnc	BT418			;  0 
	jmp	BT40			;  1 wieder von vorn
BT418:
	jnb	BFSK,BT4181             ;? FSK
	jb	BMenu,BT4181		;1 ? wurde am Drehgeber gedreht
	cpl	Brevers			;  0 Revers umpolen			
      	jmp	BT499	
BT4181:			
	mov	a,MenuTaste4		;Einstellung ist gueltig
	cjne	a,#0,BT420
	cpl	BIsFrqA
BT420:
	cjne	a,#1,BT421
	call	AGleichB
BT421:
	cjne	a,#2,BT422
	clr	BRit
	cpl	BSplit
BT422:
	cjne	a,#3,BT423
	jb	BRit,BT4221
	call	AGleichB
	clr	BIsFrqA
	clr	BSplit
	setb	BRit
	sjmp	BT423
BT4221:
	setb	BIsFrqA
	clr	BRit
BT423:
	cjne	a,#4,BT424
	call	SenderTastungEin
	call	TasteInput
	call	SenderTastungAus
BT4231:
	call	TasteStatus
	jc	BT4231
	mov	r7,#0ffh
	djnz	r7,$
	call	TasteStatus
	jc	BT4231
	sjmp	BT426
BT424:
	cjne	a,#5,BT425
	call	BandFreqMerken
	sjmp	BT426
BT425:
	cjne	a,#6,BT426
BT426:
BT499:
MenuEndeBehandlung:
	mov	Impulse,#0		;Impulse zuruecksetzen
	call	BCDToDDSNeu		;in DDS laden 
	call	LCDDisplayClear
	call	Frequenzanzeige
	jmp	BetriebsartAnzeige	;RET sparen

;--------------------------------------------------------------------------
AGleichB:
	jb	BIsFrqA,AGB1
	mov	r0,#BCDFrequenzB
	mov	r1,#BCDFrequenzA
	sjmp	AGB2
AGB1:
	mov	r0,#BCDFrequenzA
	mov	r1,#BCDFrequenzB
AGB2:
	jmp	RamToRamL4              ;ret sparen durch Jump

;--------------------------------------------------------------------------
;Funktion 	laden der entsprechenden Frequenz vom Code in den Ram
;		QRP Frequenzen

F160	db	01h,81h,50h,0
F80	db	03h,56h,0,0
F40	db	07h,03h,0,0
F30	db	10h,11h,60h,0
F20	db	14h,06h,0,0
F17	db	18h,09h,60h,0
F15	db	21h,06h,0,0
F12	db	24h,90h,60h,0
F10	db	28h,06h,0,0
FMess	db	10h,0,0,0

Bandumschalten:
	cjne	a,#11,BUS1		;? Messsendermode
	setb	BMesssender		;1
	clr	a
	mov	r0,#Temp                ;  Temp-Speicher loeschen wegen
BUS01:                                  ;  WobbelStep
	mov	@r0,a                   ;
	inc	r0
	cjne	r0,#Temp + TempLaenge,BUS01
	mov	step,#0			;  Schrittweite = 10Hz
	clr	BFast			;  Fast aus
	sjmp	BUS2
BUS1:
	clr	BMesssender		;0 Messsendermodus aus
BUS2:
	mov	r7,#8			;
	mov	r0,#BCDFrequenzA
	jb	BMesssender,BUS3
	jnb	BEEprom,FTR1		;? EEprom vorhanden
	mov	a,Band			;1
	JNB	BBandumsch,BUS4         ;  ? Bandumschaltung aktiv- oczyt pasma aktywny ??
	push	acc                     ;  1 Bandnummer ausgeben
	anl	Modulport,#11110000b
	orl	Modulport,a
	pop	acc
	sjmp	BUS5
BUS4:
	orl	Modulport,#00001111b	;  0 Port zum lesen vorbereiten
BUS5:
	mov	b,#EEFrequenzLaenge	;  Anzahl der zu lesenden Bytes
	mul	ab			;  Pos berechnen je nach Band
	add	a,#EEBandfreq		;  Anfangspos. vom EEprom add.
	mov	dpl,a			;  in den Datapointer laden
	mov	dph,#0
FTR2:
	call	EERead			;  Schleife
	mov	@r0,a			;    Byte lesen und nach Freq A laden
	inc	r0			;    eine Stelle weiter
	inc	dptr
	djnz	r7,FTR2			;  ENDE bis A und B gelesen (8 Byte) 
	call	FrequTestdec		;  ? Test ob Frequenz im Band liegt
	jc	FTR1			;  0 nein QRP Frequenz laden
	call	FrequTestInc
	jc	FTR1
	ret				;  1 alles OK 

BUS3:
FTR1:					;0 kein EEprom oder Frequenz falsch
	mov	a,Band
	cjne	a,#0,bu1
	mov	dptr,#F160
	sjmp	FrequenzToRam	
bu1:
	cjne	a,#1,bu2
	mov	dptr,#F80
	sjmp	FrequenzToRam	
bu2:
	cjne	a,#2,bu3
	mov	dptr,#F40
	sjmp	FrequenzToRam	
bu3:
	cjne	a,#3,bu4
	mov	dptr,#F30
	sjmp	FrequenzToRam	
bu4:
	cjne	a,#4,bu5
	mov	dptr,#F20
	sjmp	FrequenzToRam	
bu5:
	cjne	a,#5,bu6
	mov	dptr,#F17
	sjmp	FrequenzToRam	
bu6:
	cjne	a,#6,bu7
	mov	dptr,#F15
	sjmp	FrequenzToRam	
bu7:
	cjne	a,#7,bu8
	mov	dptr,#F12
	sjmp	FrequenzToRam	
bu8:
	cjne	a,#8,bu9
	mov	dptr,#F10		;10m
	sjmp	FrequenzToRam	
bu9:
	cjne	a,#9,bu10
	mov	dptr,#F10		;Transverter 6m
	sjmp	FrequenzToRam	
bu10:
	cjne	a,#10,bu11
	mov	dptr,#F10		;Transverter 2m
	sjmp	FrequenzToRam	
bu11:
	cjne	a,#11,bu12
	mov	dptr,#FMess
	sjmp	FrequenzToRam
bu12:
	ret

FrequenzToRam:
	mov	r7,#4
	mov	r0,#BCDFrequenzA        ;Zuerst A Frequenz
	push	dpl
	push	dph
	call	CodeToRam		;zum gemeinsamen Unterprogramm
	pop	dph
	pop	dpl
	mov	r7,#4
	mov	r0,#BCDFrequenzB        ;dann B Frequenz
	jmp	CodeToRam		;RET sparen

;------------------------------------------------------------------------------------

TRXINIT:
	anl	tmod,#0			;Register loeschen
	orl	tmod,#00010001b		;Timermodus 1 fuer Timer 0 und 1

	%IntPrioritaetSetzen
					;Interruptebenen einstellen
	call	Timer0Laden		;Zeit fuer Timer das erste mal laden
	call	Timer1Laden
	setb	tr1
	clr	BTonEin			;Ton aus
	mov	tonhoehe,#3		;Mithoerton 700 Hz

	%InterruptFreigeben(10001111b)
					;Freigabe der Interrupts 

	setb	it0			;nur auf fallende Flanke reagieren
	clr	BFast			;keine Schnellabstimmung
	clr	BSplit			;kein Splitbetrieb
	clr	BRit			;keine Rit
	clr	BFSK			;kein FSK
	clr	BRevers			;kein Revers bei FSK
	setb	BNoLock			;Empfang aktiv
	setb	BIsFrqA			;Frequenz A
	setb	BZFneuLesen		;ZF muss erst aus Eeprom geladen werden 

;es folgen Werte die im EEprom liegen

	call	EEpromVorhanden		;? Eeprom vorhanden und init
	jb	BEepromInit,TRXInit1
	jmp	TRXInit2
TRXInit1:
	call	EEZFLesen    		;1 alle Werte aus Eeprom lesen
	call	AblageSetzen
	call	EEStepRead
	call	EETLockRead
	call	EETSenderAusRead
	call	EEGeschwRead
	mov	dptr,#EEBArt
	call	EERead
	mov	c,acc.7
	mov	BKeyer,c
	mov	c,acc.6
	mov	BZFAblagePerm,c
	mov	c,acc.5
	mov	BBandgrenzen,c
	mov	c,acc.4
	mov	BBandumsch,c
	call	EEAblageLesen
	mov	dptr,#EEPS
	call	EERead
	mov	PunktSpeicher,a
	jmp	TRXInit3		;  alles ok 
TRXInit2:
	clr	a
	mov	r7,#4
	mov	r0,#BCDZF		;0 default laden
TRXInit6:
	mov	@r0,a                   ;  ZF 0 Hz
	djnz	r7,TRXInit6
	mov	step,#1			;  20 Hz
	mov	TLock,#100		;  1 Sek
	mov	TSenderAus,#50		;  500 mSek
	mov	Geschw,#80h
	mov	Punktspeicher,#4	;  Punktspeicher 100 Prozent
	clr	BKeyer			;  Keyer aus
	clr	BZFAblagePerm		;  ZF-Ablage permanent aus
	setb	BBandgrenzen		;  Bandgrenzenkontrolle ein
	mov	Temp,#0ffh
	mov	Temp + 1,#0ffh		;  Ablage alles oberhalb
	call	EEAblageSetzen
	jb	BEeprom,TRXInit4	;? Eeprom vorhanden
	jmp	TRXInit3
TRXInit4:
	mov	dptr,#EEZF		;1 ZfCW in EEprom
	mov	r0,#BCDZF
	call	EEPromWriteL4		;
	mov	dptr,#EEZFLSB		;1 ZfLSB in EEprom
	mov	r0,#BCDZF
	call	EEPromWriteL4		;
	mov	dptr,#EEZFUSB		;1 ZfUSB in EEprom
	mov	r0,#BCDZF
	call	EEPromWriteL4		;
	call	EEStepWrite
	call	EETLockWrite
	call	EETSenderAusWrite
   	call	EEGeschwWrite
	mov	a,Punktspeicher
	mov	dptr,#EEPS
	call	EEWrite	
	mov	c,BKeyer
	mov	acc.7,c
	mov	c,BZFAblagePerm
	mov	acc.6,c
	mov	c,BBandgrenzen
	mov	acc.5,c
	mov	c,BBandumsch
	mov	acc.4,c
	mov	dptr,#EEBArt
	call	EEWrite
	call	EEAblageWrite

; xxxx pasmo domyslne
TRXInit3:
	jnb	BBandumsch,TRXInit5	;? Bandumschaltung aktiv
	
; ********************* zdz **************************   
	MOV	DPTR,#EEband
	CALL	EERead		;odczyt pasma z EEpromu  po wlaczeniu syntezy
 	MOV	band,A
		
; ********************* zdz **************************	

TRXInit5:
	call	Bandumschalten
	call	BCDToDDSNeu		;DDS laden
	call	BCDToDDS		;
	call	Frequenzanzeige
	jmp	BetriebsartAnzeige	;RET sparen

;===========================================================================
EEReadBKeyer:				;Read Keyer EIN/AUS
	mov	dptr,#EEBArt
	call	EERead
	mov	c,acc.7
	mov	BKeyer,c
    	ret


EEAblageWrite:
	mov	a,Temp
	mov	dptr,#EEUp1
	call	EEWrite			;  und im EEprom speichern
	mov	a,Temp + 1
	mov	dptr,#EEUp2
	jmp	EEWrite			;  und im EEprom speichern

EEAblageLesen:
	mov	dptr,#EEUp1     	;zuerst Ablage aus EEprom lesen
	call	EERead	
	mov	Temp,a
	mov	dptr,#EEUp2
	call	EERead
	mov	Temp + 1,a
EEAblageSetzen:
	mov	a,Temp			;und dann setzen
	mov 	c,acc.7
	mov	BUp160m,c
	mov 	c,acc.6
	mov	BUp80m,c
	mov 	c,acc.5
	mov	BUp40m,c
	mov 	c,acc.4
	mov	BUp30m,c
	mov 	c,acc.3
	mov	BUp20m,c
	mov 	c,acc.2
	mov	BUp17m,c
	mov 	c,acc.1
	mov	BUp15m,c
	mov 	c,acc.0
	mov	BUp12m,c
	mov	a,Temp + 1
	mov 	c,acc.7
	mov	BUp10m,c
	ret

EEZFLesen:
	mov	r0,#BCDZF		;aus EEprom lesen
	mov	dptr,#EEZF              ;0 CW
	jb	BFSK,EZL2               ;4 FSK=CW
	MOV	A,Modulport  		;? welche Betriebsart
	anl	a,#00110000b
	cjne	a,#00100000b,EZL1
	mov	dptr,#EEZFLSB		;1 SSB unteres Seitenband
EZL1:
	cjne	a,#00010000b,EZL2
	mov	dptr,#EEZFUSB		;2 SSB oberes Seitenband
EZL2:
	jmp	EEpromReadL4		;RET sparen

EEStepRead:
	mov	dptr,#EEStep
	call	EERead
	mov	Step,a
	mov	MenuTaste2,a
	ret

EEStepWrite:
	mov	dptr,#EEStep
	mov	a,Step
	jmp	EEWrite			;RET sparen

EEGeschwWrite:
	mov	dptr,#EEGeschw
	mov	a,Geschw
	jmp	EEWrite			;RET sparen

EEGeschwRead:
	mov	dptr,#EEGeschw
	call	EERead
	mov	Geschw,a
	ret

EETLockWrite:
	mov	dptr,#EETLock
	mov	a,TLock
	jmp	EEWrite			;RET sparen

EETLockRead:
	mov	dptr,#EETLock
	call	EERead
	mov	TLock,a
	ret

EETSenderAusWrite:
	mov	dptr,#EETSenderAus
	mov	a,TSenderAus
	jmp	EEWrite

EETSenderAusRead:
	mov	dptr,#EETSenderAus
	call	EERead
	mov	TSenderAus,a
	ret
;---------------------------------------------------------------------------
;Funktion	Prueft ob EEprom vorhanden oder defekt ist
;Output	BEEprom-Bit wird gesetz oder geloescht

EEPromVorhanden:
	mov	dptr,#0
	call	EERead
	cjne	a,#1,EEV2
	setb	BEEpromInit
	sjmp	EEV3
EEV2:
	clr	BEEpromInit
	mov	a,#01
	call	EEWrite
	mov	dptr,#0
	call	EERead
	cjne	a,#01,EEV1
EEV3:
	setb	BEEprom
	ret
EEV1:
	clr	BEEProm
	ret

;---------------------------------------------------------------------------
;Funktion Schreiben von Bytes in den EEprom 
;Input	  EEpromadr in DPTR, Ramadresse in R0, (Laenge in R7)	

EEPromWriteL4:
	mov	r7,#4
EEPromWriteL:
EEPWL1:
	mov	a,@r0
	call	EEWrite
	inc	r0
	inc	dptr
	djnz	r7,EEPWL1
	ret

;---------------------------------------------------------------------------
;Funktion Lesen von Bytes aus dem EEprom 
;Input	  EEpromadr in DPTR, Ramadresse in R0, (Laenge in R7)	

EEPromReadL4:
	mov	r7,#4
EEPromReadL:
EEPRL1:
	call	EERead
	mov	@r0,a
	inc	r0
	inc	dptr
	djnz	r7,EEPRL1
	ret

;---------------------------------------------------------------------------
;Funktion	merken der Frequenz vom vorhergehenden Band und speichern

BandFreqMerken:
	jb	BMesssender,BFM2
	push	acc			;Register retten
	mov	a,Band			;welches Band
	mov	b,#EEFrequenzlaenge	;Anzahl der Bytes
	mul	ab
	add	a,#EEBandfreq		;Zur Anfangsfreq add
	mov	r7,#8			;
	mov	r0,#BCDFrequenzA
	mov	dpl,a
	mov	dph,#0
BFM1:
	mov	a,@r0
	call	EEWrite
	inc	r0
	inc	dptr
	djnz	r7,BFM1		
	pop	acc
	sjmp	BFM3
BFM2:
	call	EEStepRead		;voreingestellte Schrittweite laden
BFM3:
	ret

;===========================================================================
;Funktion	Auswerten der Impulse des Drehgebers ; BCDFrequenz =
;		Anzahl der Impulse * Frequenzsprung + BCDFrequenz
;Input		A = Anzahl der Impulse; ACC.7 gesetzt ist Abwaerts
;Output		neue BCDFrequenz

DrehgeberAuswertung:
	mov	impulse,#0		;Impulse wieder auf 0 setzen
	jb	BMesssender,dreh01	;
	jb	BFSK,dreh01             ;Bei FSK immer Aenderung moeglich
	JB	BNoLock,dreh01		;? Lock noch aktiv & Keyer aktiv 
	jnb	BKeyer,dreh01		;
	jmp	dreh98			;bei "Keyer ein" beim Senden Geschw.einst.
dreh01:
	; pominiecie krecenie  jezeli bit BNoLock 0  yyyyy
	
	JB 	BNoLock, dreh01a
	JMP	dreh99

dreh01a:

;======================================== stepswj

$include (stepds.inc)

;================================================

dreh6:
	pop	acc			;    Impulse wieder in A                                                                      
	jb	acc.7,dreh1		;    ? Drehrichtung recht herum                                                                      
	mov	r4,a			;    JA Impulse in Schleifenzaehler                                                                      
dreh7:
	call	LoadR03
	mov	r1,#BCDImpulse+3
	call	ADD_BCD			;    Frequenzschritt addieren                                                                      
	jb	BMesssender,dreh71
	jnb	BBandgrenzen,dreh71	;    ? Bandgrenzenkontrolle                                   
	call	Frequtestinc            ;    1 testen                                   
	jnc	dreh71
	call	LoadR03
	mov	r1,#BCDImpulse+3
	call	SUBB_BCD		;    Frequenzschritt wieder subtrahieren                                                                      
dreh71:
	djnz	r4,dreh7		;    ? alle Impulse abgearbeitet                                                                      
	sjmp	dreh2			;    ja Sprung                                                                      
dreh1:
	cpl	a			;    Drehrichtung ist links herum                                                                      
	inc	a			;    negieren = Anzahl der Impulse                                                                      
	mov	r4,a			;    und Schleifenzaehler laden                                                                      
dreh8:
	call	LoadR03
	mov	r1,#BCDImpulse+3
	call	SUBB_BCD		;    Frequenzschritt subtrahieren                                                                      
	jb	BMesssender,dreh81
	jnb	BBandgrenzen,dreh81	;    ? Bandgrenzenkontrolle                                   
	call	Frequtestdec		;    1 testen                                   
	jnc	dreh81
	call	LoadR03
	mov	r1,#BCDImpulse+3
	call	ADD_BCD			;    Frequenzschritt wieder addieren                                                                      
dreh81:
	djnz	r4,dreh8		;    ? alle Impulse abgearbeitet                                                                      
dreh2:
	call	BCDToDDSNeu		;    ja BCD-Zahl umrechnen und in DDS                                                                      
	call	Frequenzanzeige		;    neue Frequenz anzeigen                                                                      
	sjmp	dreh99
dreh98:
	cpl	a			;  1 Impulse negieren                                                          
	inc	a
	add	a,Geschw		;    add oder sub der Impulse                                                          
	mov	Geschw,a		;
	call	LCDDisplayClear
	%WriteStrXY(1,1,'Klucz:')
	mov	a,Geschw
	cpl	a
	call	HexToDez
	%WriteXYOhneNull(8,1,Temp)
	mov	TimerLock,TLock		;    Lockzeit neu starten                                   
dreh99:
	ret				;1 Ende

;--------------------------------------------------------------------
;Funktion	Der Inhalt des Reg. A wird von Hex in Dez gewandelt
;In		Hex in Register A
;Out		Dez in Temp und Temp + 1
;Register	A, B

HexToDez:
	mov	b,#100
	div	ab
	mov	Temp,a
	mov	a,#10
	xch	a,b
	div	ab
	swap	a
	add	a,b
	mov	Temp + 1,a
	ret

;--------------------------------------------------------------------
;Funktion	Ausgabe von Temp als ASCII auf der LCD ohne fuehrende Null
;In		In Temp Dezimalzahl
;Out		Zahl steht auf der LCD
;Register	A,

WritePuffer:
	mov	a,Temp		;Erstes Byte laden
	push	acc		;merken
	swap	a		;HI und Low tauschen oberes Nibbel zuerst
	call	BCDToAscii	;In ASCII wandeln
	cjne	a,#30h,WB1	;? NULL
	call	LCDSpace	;1 Leerzeichen ausgeben
	sjmp	WB2
WB1:
	setb	bNoNull		;0 keine fuehrende Null Merkbit setzen
	call	LCDChar		;Zeichen ausgeben
WB2:
	pop	acc		;unteres Nibbel ist jetzt dran
	call	BCDToAscii
	jb	bNoNull,WB3	;? erste Zahl war keine Null 
	cjne	a,#30h,WB3	;0 ? Test auf Null
	call	LCDSpace	;  1 Leerzeichen ausgeben
	sjmp	WB4
WB3:
	setb	bNoNull		;  0 keine Null merken
	call	LCDChar		;    Zeichen ausgeben
WB4:
	mov	a,Temp+1	;zweites Byte ausgeben
	push	acc
	swap	a
	call	BCDToAscii
	jb      bNoNull,WB5
	cjne	a,#30h,WB5
	call	LCDSpace
	sjmp	WB6
WB5:
	call	LCDChar
WB6:
	pop	acc
	call	BCDToAscii	;letzte Ziffer auf alle Faelle ausgeben
	jmp	LCDChar		;RET sparen

;===========================================================================
;Funktion	Laden der Endadresse der A oder B Frequ. in das Reg. R0


Loadr03:
	mov	r0,#BCDFrequenzA + 3
	jb	BIsFrqA,LR1
	mov	r0,#BCDFrequenzB + 3
LR1:
	ret

;===========================================================================
;Funktion	Laden der Anfangsadresse der A oder B Frequ. in das Reg. R0

Loadr0:
	mov	r0,#BCDFrequenzA
	jb	BIsFrqA,LR01
	mov	r0,#BCDFrequenzB
LR01:
	ret

;===========================================================================
;Funktion	Test ob Band unterschritten wird
;In		Frequenz und Festgelegte Bandgrenzen
;Out		C gesetzt bei Ueberschreitung der Bandgrenze
	
Frequtestdec:
	call	LoadR03
FrequtestdecQ:
	mov	r7,#4 
	mov	dptr,#fdec
	mov	a,Band
	rl	a
	rl	a
	add	a,#3
	mov 	r6,a
	clr	c
Frqd1:
	mov	a,r6
	movc	a,@a+dptr
	subb	a,@r0
	dec	r0
	dec	r6
	djnz	r7,Frqd1
	cpl	c
	ret


;==============

$include (BFDown.inc)

;===========================================================================
;Funktion	Test ob Band ueberschritten wird
;In		Frequenz und Festgelegte Bandgrenzen
;Out		C gesetzt bei Ueberschreitung der Bandgrenze

Frequtestinc:
	call	LoadR03
FrequtestincQ:
	mov	r7,#4 
	mov	dptr,#finc
	mov	a,Band
	rl	a
	rl	a
	add	a,#3
	mov 	r6,a
	clr	c
Frqi1:
	mov	a,r6
	movc	a,@a+dptr
	subb	a,@r0
	dec	r0
	dec	r6
	djnz	r7,Frqi1
	ret

$include (BFUp.inc)



;===========================================================================
;Funktion	DDS-IC voreinstellen

DDSInit:
	clr	SData
	clr	FQ_UD
	CLR	SClk
	
;inicjalizacja DDSa zabezpieczajaca  przed trybem serwisowym

MOV	A,#00000000b	
	call	ByteToDDS	
 	CLR	FQ_UD		
	setb	FQ_UD
	clr	FQ_UD
MOV	A,#00000000b	
	call	ByteToDDS	
 	CLR	FQ_UD		
	setb	FQ_UD
	clr	FQ_UD
MOV	A,#00000000b	
	call	ByteToDDS	
 	CLR	FQ_UD		
	setb	FQ_UD
	clr	FQ_UD
MOV	A,#00000000b	
	call	ByteToDDS	
 	CLR	FQ_UD		
	setb	FQ_UD
	clr	FQ_UD
MOV	A,#00000000b	
	call	ByteToDDS	
 	CLR	FQ_UD		
	setb	FQ_UD
	clr	FQ_UD

; koniec inicjalizacji	zabezpieczajacej przed trybem serwisowym
	
	ret

;===========================================================================
;Funktion	BCDFrequenz A oder B in BCDDDS kopieren

BCDCopyA:
	mov	r0,#BCDFrequenzA
	sjmp	BCDC1
BCDCopyB:
	mov	r0,#BCDFrequenzB
	sjmp	BCDC1
BCDCopy:
	call	LoadR0
BCDC1:
	mov	r1,#BCDDDS
RamToRamL4:
	mov	r7,#4
RamToRam:
	mov	a,@r0		;Frequenz kopieren
	mov	@r1,a
	inc	r0
	inc	r1
	djnz	r7,RamToRam
	ret

;---------------------------------------------------------------------------
;Funktion	vom BCDDDS ZF Addieren oder Subdrahieren

ZFADD_SUB:
	mov	a,Band
	cjne	a,#0,ZFAS01		;? 160m
	jnb	BUp160m,ZFAS002  	;? ZF Addieren
	jmp	ZFASADD			;1 ja
ZFAS002:
	jmp	ZFASSUBB		;0 nein
ZFAS01:
	cjne	a,#1,ZFAS02
	jnb	BUp80m,ZFAS012   	;? ZF Addieren
	jmp	ZFASADD			;1 ja
ZFAS012:
	jmp	ZFASSUBB		;0 nein
ZFAS02:
	cjne	a,#2,ZFAS03
	jnb	BUp40m,ZFAS022		;? ZF Addieren
	jmp	ZFASADD			;1 ja
ZFAS022:
	jmp	ZFASSUBB		;0 nein
ZFAS03:
	cjne	a,#3,ZFAS04
	jnb	BUp30m,ZFAS032   	;? ZF Addieren
	jmp	ZFASADD			;1 ja
ZFAS032:
	jmp	ZFASSUBB		;0 nein
ZFAS04:
	cjne	a,#4,ZFAS05
	jnb	BUp20m,ZFAS042   	;? ZF Addieren
	jmp	ZFASADD			;1 ja
ZFAS042:
	jmp	ZFASSUBB		;0 nein
ZFAS05:
	cjne	a,#5,ZFAS06
	jnb	BUp17m,ZFAS052   	;? ZF Addieren
	jmp	ZFASADD			;1 ja
ZFAS052:
	jmp	ZFASSUBB		;0 nein
ZFAS06:
	cjne	a,#6,ZFAS07
	jnb	BUp15m,ZFAS062   	;? ZF Addieren
	jmp	ZFASADD			;1 ja
ZFAS062:
	jmp	ZFASSUBB		;0 nein
ZFAS07:
	cjne	a,#7,ZFAS08
	jnb	BUp12m,ZFAS072   	;? ZF Addieren
	jmp	ZFASADD			;1 ja
ZFAS072:
	jmp	ZFASSUBB		;0 nein
ZFAS08:
	cjne	a,#8,ZFAS073
	sjmp	ZFAS075
ZFAS073:
	cjne	a,#9,ZFAS074
	sjmp	ZFAS075
ZFAS074:
	cjne	a,#10,ZFAS09
ZFAS075:
	jnb	BUp10m,ZFAS082   	;? ZF Addieren
	jmp	ZFASADD			;1 ja
ZFAS082:
	jmp	ZFASSUBB		;0 nein
ZFAS09:
ZFASADD:
	mov	r0,#BCDDDS+3
	mov	r1,#BCDZf+3
	jmp	ADD_BCD			;RET sparen

ZFASSUBB:
	mov	r0,#BCDDDS+3
	mov	r1,#BCDZf+3
	jmp	SUBB_BCD		;RET sparen

;---------------------------------------------------------------------------
;Funktion	Add oder Sub der ZF
;Konstande	FSK Shift 170 Hz fuer Kurzwelle

FSKShift	db	00h,00h,01h,70h

ADDFSKShift:
	mov	dptr,#FSKShift
	mov	r7,#4
	mov	r0,#temp
	call	CodeToRam
	mov	r0,#BCDDDS+3
	mov	r1,#Temp+3
	jmp	ADD_BCD			;RET sparen
;---------------------------------------------------------------------------
;Funktion	BCD umrechnen in 32 Bit + laden in DDS

FMTTX1Laden:
	call	BinaerUmrechnen
	mov	r1,#FMTTX1
	sjmp	FMTTX01
FMTRXLaden:
	call	BinaerUmrechnen
	mov	r1,#FMTRX
	sjmp	FMTTX01
FMTTXLaden:
	call	BinaerUmrechnen
	mov	r1,#FMTTX
FMTTX01:
	mov	r0,#Temp 
	jmp	RamToRamL4		;RET sparen


BCDToDDSNeu:
	clr	Virtuell_ien0.7		;Alle Interrupts sperren
	jnb	BZFneuLesen,BTD001
	call	EEZFLesen
	clr	BZFneuLesen
BTD001:
	jnb	BMesssender,BTD01	;? Messsenderbetrieb
	call	BCDCopy			;1
	call	FMTRXLaden
	jmp	BCDToDDS		
BTD01:
	jnb	BRit,BTD02		;0 ? Betriebsart
	call	BCDCopyB		;  1 Rit
	call	ZFADD_SUB
	call	FMTRXLaden
	call	BCDCopyA
;******* swj ZF sub in non CW
	JNB	BKeyerRead,BTD03a       ; jezeli tryb CW MHz  zawsze DODAJE posrednia
	JNB	BZFAblagePerm,BTD03	;    ? ZF perm  pominiecie dodawania poredniej
;******** swj ZF sub in non CW
BTD03a:	
 	call	ZFADD_SUB		;    1 ZF add oder sub
BTD03:	

	call	FMTTXLaden
	jnb	BFSK,BTD04		;    ? FSK	
	call	ADDFSKShift		;    1 Shift add
	call	FMTTX1Laden
BTD04:
	jmp	BCDToDDS
BTD02:
	JNB	BSPLIT,BTD05		;  2 Split
	call	BCDCopy			;  
	call	ZFADD_SUB
	call	FMTRXLaden
	cpl	BisFrqA
	call	BCDCopy
;******* swj ZF sub in non CW
	JNB	BKeyerRead,BTD06a       ; jezeli tryb CW MHz  zawsze DODAJE posrednia
	JNB	BZFAblagePerm,BTD06	;    ? ZF perm
;******* swj ZF sub in non CW
BTD06a:
	call	ZFADD_SUB		;    1 ZF add oder sub
BTD06:
	call	FMTTXLaden
	jnb	BFSK,BTD07		;    ? FSK
	call	ADDFSKShift		;    1 Shift add
	call	FMTTX1Laden
BTD07:
	cpl	BisFrqA
     	jmp	BCDToDDS
BTD05:
	call	BCDCopy			;  0 normal
;******* swj ZF sub in non CW
	JNB	BKeyerRead,BTD08a       ; jezeli tryb CW MHz  zawsze DODAJE posrednia
	JNB	BZFAblagePerm,BTD08	;    ? ZF perm
;******* swj ZF sub in non CW
BTD08a:
	call	ZFADD_SUB               ;    1
BTD08:
	call	FMTTXLaden
;******* swj ZF sub in non CW
	JNB	BKeyerRead,BTD10a       ; jezeli tryb CW MHz  zawsze DODAJE posrednia
	JNB	BZFAblagePerm,BTD10	;    ? ZF perm
;******* swj ZF sub in non CW
BTD10a:
	MOV	R0,#Temp 		;    1 TX = RX
	mov	r1,#FMTRX
	call	RamToRamL4
BTD10:
	jnb	BFSK,BTD09		;    ? FSK	
	call	ADDFSKShift		;    1 die Shiftfrequenz
	call	FMTTX1Laden
BTD09:	
	jb	BZFAblagePerm,BTD11	;    ? ZF perm
	call	BCDCopy			;    0 Empfangsfrequenz aufbereiten
	call	ZFADD_SUB		;      ZF add oder sub
	call	FMTRXLaden
BTD11:
BCDToDDS:
FMTToDDS:
	clr	Virtuell_ien0.7		;Alle Interrupts sperren
	jb	BMesssender,FTD01       ;? Messsenderbetrieb
	jnb	BFSK,FTD02		;0 ? FSK 
	jb	TxTastung,FTD04		;  1 ? Tastung ein
	jb	Punktpaddel,FTD06	;    1 ? Shift ein
	jnb	Brevers,FTD08		;      1 ? Revers	
	sjmp	FTD03			;        1 Tx = Sendefrequenz   
FTD06:                       		;	 0 Tx1 = Sendefrequenz
	jnb	Brevers,FTD03		;      0 ? Revers	
	sjmp	FTD08			;	 1 Tx1 = Sendefrequenz
FTD08:					;	 0 Tx = Senderfrequenz
	mov	r0,#FMTTX1 + 3          ;
	sjmp	FTDLaden
FTD03:
	mov	r0,#FMTTX + 3		;
	sjmp	FTDLaden
FTD04:
	mov	r0,#FMTRX + 3		;    0 Rx
	sjmp	FTDLaden
FTD02:
	jb	TxTastung,FTD05		;  0 ? Tastung ein
	mov	r0,#FMTTX + 3		;    1 Tx
	sjmp	FTDLaden
FTD05:
FTD01:
	mov	r0,#FMTRX + 3		;    0 Rx
FTDLaden:				;1 Rx 
	MOV	R6,#4			;4 Byte in DSS laden  
FMTToDDS1:
	mov	a,@r0
	call	ByteToDDS    		;Byte fuer Byte
	dec	r0           		;nachstes Byte
	djnz	r6,FMTToDDS1

$include (mnoznik.inc)

	call	ByteToDDS		; Multiplier, Control, Power-down, Phase
 	CLR	FQ_UD			; Frequenz vom seriellen Speicher(DDS) in Ausgabe laden
	setb	FQ_UD
	clr	FQ_UD
	setb	Virtuell_ien0.7		;alle Interrupts freigeben
	ret				;fertig

;Zwischenfunktion zum Zusammenfassen

BinaerUmrechnen:
	mov	Temp,#0       	;loeschen Temp-Speichers
	mov	Temp+1,#0
	mov	Temp+2,#0
	mov	Temp+3,#0
	call	M10Mhz		;Jede dezimalstelle einzeln berechnen
	call	M1Mhz
	call	M100khz
	call	M10khz
	call	M1khz
	call	M100hz
	call	M10hz
	jmp	M1hz		;RET sparen

;laden eines Bytes in den DDS-IC

ByteToDDS:
	mov	r5,#8		;8 Bit
ByteToDDS3:
	rrc	a		;niederwertiges Bit in C schieben
	jnc	ByteToDDS1	;? wert=0
	setb	SData		;wert=1
	sjmp	ByteToDDS2
ByteToDDS1:
	clr	SData
ByteToDDS2:
	setb	SClk		;LHL-Impuls an CLK
	clr	SClk
	djnz	r5,ByteToDDS3	
	ret
;--------------------------------------------------------------------------
;Funktion	laden von bytes im Code zum Ram

CodeToRam:
	push	acc
CTR:
	clr     a
	movc	a,@a+dptr
	mov	@r0,a
	inc	dptr
	inc	r0
	djnz	r7,CTR
	pop	acc
	ret

;Funktion	Laden einer BCDKonstande vom Code in den Zwischenspeicher
;Input		Code-Adresse in DPTR, Ziel in R0
;Register	r0, r7

KonstToFMTZw:
	mov	r0,#FMTZw		;Zwischenspeicher adressieren
	mov	r7,#4			;4 Byte
	sjmp	CodeToRam


MulKonst:
	anl	a,#0fh		;nur unteres Nibbel zaehlt
	mov	r6,a		;Multiplikator in A
	mov	r0,#FMTZw + 3
	mov	r7,#4		;4 BCD-Stellen
	mov	Uebertrag,#0	;Uebertrag =0
MKonst1:
	mov	b,r6		;
	mov	a,@r0		;niedrigste Stelle zuerst multiplizieren
	mul	ab
	add	a,Uebertrag	;Uebertrag von vorheriger Multiplikation 
	mov	Uebertrag,b	;neuen Uebertrag merken
	jnc	MKonst3		;? summe > 255
	inc	uebertrag	;ja zum hoeherwertigen Byte 1 addieren
MKonst3:
	mov	@r0,a		;Ergebnis abspeichern
	dec	r0		;naechste hoeherwertige Stelle
	djnz	r7,MKonst1	;? alle Bytes multipliziert
	mov	r0,#Temp + 3	;Zwischenergebnis zum FMTRX addieren
	mov	r1,#FMTZw + 3
	mov	r7,#4        	;wieder 4 Byte
	clr	c		;ueberlauf loeschen
MKonst2:
	mov	a,@r1
	addc	a,@r0		;und addieren
	mov	@r0,a
	dec	r0
	dec	r1
	djnz	r7,MKonst2
	ret			;fertig
;---------------------------------------------------------------------------
;Hexkonstanden fuer jede Dezimalstelle einzeln errechnet

M10Mhz:
	mov	dptr,#k10Mhz		;konstande in dptr laden
	call	KonstToFMTZw
	mov	a,BCDDDS
	swap	a
	jmp	MulKonst
;---------------------------------------------------------------------------
M1Mhz:
	mov	dptr,#k1Mhz		;konstande in dptr laden
	call	KonstToFMTZw
	mov	a,BCDDDS
	jmp	MulKonst
;---------------------------------------------------------------------------
M100khz:
	mov	dptr,#k100khz		;konstande in dptr laden
	call	KonstToFMTZw
	mov	a,BCDDDS + 1
	swap	a
	jmp	MulKonst
;---------------------------------------------------------------------------
M10khz:
	mov	dptr,#k10khz		;konstande in dptr laden
	call	KonstToFMTZw
	mov	a,BCDDDS + 1
	jmp	MulKonst
;---------------------------------------------------------------------------
M1khz:
	mov	dptr,#k1khz		;konstande in dptr laden
	call	KonstToFMTZw
	mov	a,BCDDDS + 2
	swap	a
	jmp	MulKonst
;---------------------------------------------------------------------------
M100hz:
	mov	dptr,#k100hz		;konstande in dptr laden
	call	KonstToFMTZw
	mov	a,BCDDDS + 2
	jmp	MulKonst
;---------------------------------------------------------------------------
M10hz:
	mov	dptr,#k10hz		;konstande in dptr laden
	call	KonstToFMTZw
	mov	a,BCDDDS + 3
	swap	a
	jmp	MulKonst
;---------------------------------------------------------------------------
M1hz:
	mov	dptr,#k1hz		;konstande in dptr laden
	call	KonstToFMTZw
	mov	a,BCDDDS + 3
	jmp	MulKonst
;---------------------------------------------------------------------------
;Funktion	Anzeige der Frequenz auf dem Display mit Komma ,Punkt und
;		MHz Angabe

Stellen	equ	7		;Anzahl der Stellen die angezeigt werden

LCDOutZahl:
	anl	a,#0fh
	orl	a,#30h
	cjne	r7,#Stellen,LOZ1	;unterdrueckung der 1. Null
	cjne	a,#30h,LOZ1
	mov	a,#' '
LOZ1:
	jmp	LCDChar			;RET sparen

;---------------------------------------------------------------------------
;Frequenzkonstanden fuer 6m und 2m in Spiegelschrift

F6M	db	0,0,0,22H
F2M	db	0,0,0,16H
;---------------------------------------------------------------------------
;Funktion 	Laden der entsprechenden Anzuzeigenden Frequenz im Reg R0
;		Band Nr 9 und 10 werden bei der Anzeige noch Frequenzen
;		addiert

AnzTransverter:
	mov	a,Band
	cjne	a,#9,AT01
	mov	dptr,#F6M
	sjmp	AT04
AT01:
	cjne	a,#10,AT02
	mov	dptr,#F2M
AT04:
	mov	a,r0
	add	a,#3
	mov	r1,a
	mov	r0,#Temp + 3
	call	ADD_BCD_C
	mov	r0,#Temp
AT02:
  	ret


FrequenzAnzeige:

	JB	BSplit,emptyLCDA
	JB	BRit,emptyLCDA
	
	%WriteStrXY(1,1,'A ')
	SJMP AonLCD
	
emptyLCDA:
	%WriteStrXY(1,1,'  ')
	
AonLCD:
	MOV	R0,#BCDFrequenzA
	call	AnzTransverter	
	call	FrequenzAnz
; = = = = ====
	JB	BSplit,emptyLCDB
	JB	BRit,emptyLCDB
	
	%WriteStrXY(1,2,'B ')
	SJMP BonLCD
emptyLCDB:
	%WriteStrXY(1,2,'  ')
		
BonLCD:
	MOV	R0,#BCDFrequenzB
	call	AnzTransverter
	
	
	
	
FrequenzAnz:
	mov	r7,#Stellen
FA1:
	cjne	r7,#Stellen -2,FA2	;? Mhz wird unterschritten
	mov	a,#','			;ja Komma einfuegen
	call	LCDChar			;ausgeben
FA2:
	mov	a,@r0			;Zeichen holen
	push	acc
	swap	a			;1.Nippel verwenden
	call	LCDOutZahl		;anzeigen
	dec	r7	    		;ein Zeichen angezeigt
	cjne	r7,#0,FA21
	pop	acc

;============================================== 1Hz
	Call	LCDOutZahl
	sjmp	FA4             ; zdz 1Hz
;==============================================
FA21:


	cjne	r7,#Stellen -5,FA3	;? x. Zeichen von rechts
	mov	a,#'.'			;ja Punkt ausgeben
	call	LCDChar
FA3:
	pop	acc
	Call	LCDOutZahl
	inc	r0
	djnz	r7,FA1
FA4:
	ret
;---------------------------------------------------------------------------
;Funktion	Anzeige der Betriebsart und des Filter auf LCD






BetriebsartAnzeige:
	jnb	BFast,BA0
	mov	a,#11
	jb	BIsFrqA,BA01
	mov	a,#11 + 40h
BA01:
	call	LCDPos
	mov	a,#'*'
	call	LCDChar
BA0:
	jnb	BFSK,BA001
	clr	BKeyerRead     		;Vorbereiten zum Keyermodus nachl.
	jnb	Brevers,BA002        
	%WriteStrXY(14,1,'FSR')
	sjmp	BA003
BA002:
	%WriteStrXY(14,1,'FSK')
BA003:
	jmp	BA4
BA001:
	mov	a,ModulPort
	anl	a,#00110000b
	cjne	a,#0,BA1
	%WriteStrXY(14,1,'CW ')
	jb	BKeyerRead,BA1		;? wurde Keyermodus gelesen
	call	EEReadBKeyer		;0 Keyermodus lesen
	SETB	BKeyerRead		;  Merbit setzen, sonst unnoetiges
					;  Lesen
BA1:
	cjne	a,#00010000b,BA2
	%WriteStrXY(14,1,'USB')
	clr	BKeyerRead	       	;Vorbereiten zum Keyermodus nachl.
	clr	BKeyer	
BA2:
	cjne	a,#00100000b,BA3
	%WriteStrXY(14,1,'LSB')
	clr	BKeyerRead	       	;Vorbereiten zum Keyermodus nachl.
	clr	BKeyer	
BA3:
	cjne	a,#00110000b,BA4
	%WriteStrXY(14,1,'CWn')
	jb	BKeyerRead,BA4		;? wurde Keyermodus gelesen
	call	EEReadBKeyer		;0 Keyermodus lesen
	setb	BKeyerRead		;  Merbit setzen, sonst unnoetiges
					;  Lesen
BA4:
	jnb	BSplit,BA5
	mov	a,#14 + 3fh
	call	LCDPos
	mov	a,#'S'			; S  split zaaczony
	call	LCDChar

						
						
	JB	BIsFrqA,jsspln
jssplr:					; SPLIT  info na LCD   VFO B dolne aktywne
	%WriteStrXY(1,1,'N')
	%WriteStrXY(1,2,'O')
	SJMP jssplk
jsspln:					; SPLIT  info na LCD   VFO A gorne aktywne
	%WriteStrXY(1,1,'O')
	%WriteStrXY(1,2,'N')
jssplk:

	
	
BA5:
	jnb	BRit,BA6
	mov	a,#14 + 3fh
	call	LCDPos
	mov	a,#'R' 			; R  rit zalaczony
	call	LCDChar
						; RIT info na LCD
	%WriteStrXY(1,1,'N')
	%WriteStrXY(1,2,'O')
	
BA6:
	jb	BIsFrqA,BA7
	%WriteStrXY(2,2,'>')
	sjmp	BA8
BA7:
	%WriteStrXY(2,1,'>')
BA8:
	jb	BMesssender,BA9
	ret
;                       ===========================  koniec  BetriebsartAnzeige



BA9:

;=====================================stepswj
$include (stepgls.inc)


;---------------------------------------------------------------------------
;Funktion	Addieren von 2 BCD-Zahlen 4-Byte Laenge ein Summand im Code
;Input		Summand in DPTR, Summand in @R1
;Output		Summe in @R0

ADD_BCD_C:
	mov	r2,#4
	CLR	C		;CY loeschen
ADC0:	mov	bitc,c
	CLR	A
	MOVC	A,@A+DPTR	;1.Summand laden
	mov	c,bitc
	ADDC	A,@R1		;2.Summand addieren
	DA	A		;Dezimalkorrektur			**1
	MOV	@R0,A		;Ergebnis abspeichern
	inc	dptr
	dec	R0		;Naechstes Byte 1.Summand
	dec	R1		;    "      "   2.Summand
	DJNZ	R2,ADC0		;Addition beendet ?
	RET			;
;---------------------------------------------------------------------------
;Funktion	Addieren von 2 BCD-Zahlen 4-Byte Laenge
;Input		Summand in @R0, Summand in @R1
;Output		Summe in @R0

ADD_BCD:
	mov	r2,#4
	CLR	C		;CY loeschen
AD0:	MOV	A,@R0		;1.Summand laden
	ADDC	A,@R1		;2.Summand addieren
	DA	A		;Dezimalkorrektur			**1
	MOV	@R0,A		;Ergebnis abspeichern
	dec	R0		;Naechstes Byte 1.Summand
	dec	R1		;    "      "   2.Summand
	DJNZ	R2,AD0		;Addition beendet ?
	RET			;
;---------------------------------------------------------------------------
;Funktion	Subtrahieren von 2 BCD-Zahlen 4 Byte laenge
;Input		Minuend in @R0, Subtrahend in @R1
;Output		Ergebnis in @R0

SUBB_BCD:
	mov	r2,#4
	CLR	C		;CY loeschen
SB1:	MOV	A,@R0		;Minuend laden
	SUBB	A,@R1		;Subtrahend subtrahieren
SB2:	JBC	CY,SB3		;Sprung, falls Ergebnis negativ		**2
	JNB	AC,SB5		;Falls CY=0 und AC=0 Sprung		**3
	SUBB	A,#06H		;Dezimalkorrektur niederes Halbbyte	**4
	SJMP	SB5		;CY=0					**5
SB3:	JNB	AC,SB4		;Sprung, falls AC=0			**6
	SUBB	A,#06H		;Dezimalkorrektur niederes Halbbyte	**7
SB4:	SUBB	A,#60H		;        "        oberes Halbbyte	**8
	SETB	C		;CY=1 : negatives Ergebnis		**9
SB5:	MOV	@R0,A		;Ergebnis abspeichern
	dec	R0		;Naechstes Byte subtrahieren
	dec	R1		;    "       "  Minuend
	DJNZ	R2,SB1		;Subtraktion beendet ?
	RET			;
;----------------------------------------------------------------------------
;Anfangsmarkierung
	db	00,0ffh

;Hexkonstanden fuer 100 MHz

k10Mhz	db	19h,99h,99h,9ah
k1Mhz	db	02h,8fh,05ch,029h
k100Khz	db	0,41h,89h,37h
k10khz	db	0,6h,8dh,0b9h
k1khz	db	0,0,0a7h,0c6h
k100hz	db	0,0,10h,0c7h
k10hz	db	0,0,1,0adh
k1hz	db	0,0,0,2bh

; Konstanden fuer 125 MHz

;k10Mhz		db	14h,7ah,0e1h,48h
;k1Mhz		db	02h,0ch,049h,0bah
;k100Khz	db	0,34h,6dh,0c6h
;k10khz		db	0,5h,3eh,2dh
;k1khz		db	0,0,86h,38h
;k100hz		db	0,0,0dh,6ch
;k10hz		db	0,0,1,58h
;k1hz		db	0,0,0,22h

;Endmarkierung
	db	0ffh, 0
;============================================================================
END
