;Macro-bersicht
;InitLCD(Text1,Text)
;===================
;WriteZeile1(Text)
;====================
;WriteZeile2(Text)
;====================
;WriteStrXY(x,y,Text)
;====================
;WriteByteXY(x,y,Text)
;====================
;LCDMenuEinAus(BitVar,Text)
;==========================
;Initialisierung des LCD-Anzeige mit Reservierung der Speicherplaetze
;fuer die Texte
;---------------------------------------------------------------------

;Funktionsuebersicht
;######################################################################
;LCDInit:
;=======
;Initialisierung der LCD-Anzeige auf dem Port 1 und Ausgabe des Textes
;----------------------------------------------------------------------
;LCDCom:
;======
;Ausgabe eines LCD-Commandos zur Steuerung der LCD
;Befehl im Register A
;----------------------------------------------------------------------
;LCDDisplayClear:
;===============
;Loeschen des LCD-Displays
;----------------------------------------------------------------------
;LCDCursorHome:
;=============
;Kursor an den Anfang des LCD-Display
;----------------------------------------------------------------------
;LCDHomeZeile1:
;=============
;Kursor an den Anfang der 1.Zeile
;----------------------------------------------------------------------
;LCDHomeZeile2:
;=============
;Kursor an den Anfang der 2.Zeile
;----------------------------------------------------------------------
;LCDShiftRechts:
;===============
;Display nach rechts verschieben
;----------------------------------------------------------------------
;LCDShiftLinks:
;==============
;Display nach links verschieben
;----------------------------------------------------------------------
;LCDEntryShift:
;==============
;Diplay automatisch verschieben wenn Cursor aus dem Sichtbereich lauft
;----------------------------------------------------------------------
;LCDPos:
;======
;Position in Register A
;----------------------------------------------------------------------
;LCDChar:
;=======
;Ausgabe eines Chars auf dem Display
;Char in Register A
;----------------------------------------------------------------------
;LCDSpace:
;========
;Ausgabe eines Lehrzeichens
;----------------------------------------------------------------------
;LCDOutStrZeile1:
;==============
;Ausgabe eines Strings auf der 1.Zeile Stringabschluss mit 0
;Stringanfang im Register DPTR
;String steht im Codesegment
;----------------------------------------------------------------------
;LCDOutStrZeile2:
;==============
;Ausgabe eines Strings auf der 2.Zeile Stringabschluss mit 0
;Stringanfang im Register DPTR
;String steht im Codesegment
;----------------------------------------------------------------------
;LCDStr:
;==============
;Ausgabe eines Strings Stringabschluss mit 0
;Stringanfang im Register DPTR
;String steht im Codesegment
;----------------------------------------------------------------------
;LCDOutByte:
;==========
;Ausgabe eines Wertes in Hex
;Werte steht im A-Register
;----------------------------------------------------------------------
;LCDCBit:
;========
;Funktion	Ausgabe von "1" oder "0" jenachdem ob C-Flag gesetzt
;In		C-Flag
;----------------------------------------------------------------------
;LCDRegRZeile1:
;==============
;Funktion	Ausgabe der R-register auf der 1. Zeile auf dem Display
;		beginnend mit r0 r1 r2 r3 r4 r5 r6 r7 in hexadezimaler Form
;----------------------------------------------------------------------
;LCDRegRZeile2:
;==============
;Funktion	Ausgabe der R-register auf der 2. Zeile auf dem Display
;		beginnend mit r0 r1 r2 r3 r4 r5 r6 r7 in hexadezimaler Form
;----------------------------------------------------------------------
;LCDRegister:
;=============
;Funktion	Ausgabe der Register auf dem Display
;		Zeile1 R-Register
;		Zeile2 CPU-Register PSW,SP,DPTR
;----------------------------------------------------------------------
;LCDRegisterStop:
;================
;Funktion	Ausgabe der Register auf dem Display + Stop mit Software
;		Zeile1 R-Register
;		Zeile2 CPU-Register PSW,SP,DPTR
;----------------------------------------------------------------------
;LCDDefine:
;==========
;Funktion	Definieren eigener Ascii-Zeichen im Adressbereich 0-7
;In		In DPTR Tabelle im Codebereich, in A Speicherplatz 0..7
;Out		Zeichen in der LCD definiert
;Register	DPTR, R0
;----------------------------------------------------------------------
;LCDDefineSonderzeichen:
;=======================
;Funktion	Alle Sonderzeichen in LCD laden
;----------------------------------------------------------------------

;#################### Begin der Macros ############################

;=================================================================  InitLCD

%*DEFINE (InitLCD(LCDText1,LCDText2))LOCAL LCDDTEXT1 LCDDTEXT2 INITLCD1 LCDINIT2(
	Call	LCDInit
	Call	LCDInit				;swj   2xiniet od ZDZ
	call	LCDDisplayClear
	call	LCDCursorHome
	call	LCDOutStrZeile1
%LCDDTEXT1	db      %LCDText1,0
	call	LCDOutStrZeile2
%LCDDTEXT2	db	%LCDText2,0
        call    sleep
)

;=================================================================  WriteStrXY

%*DEFINE (WriteStrXY(x,y,Text))LOCAL WriteStrXYText (
	call	LCDStr
%WriteStrXYText	db     2,(%x-1)+((%y-1)*40h),%Text,0
)

;=================================================================  WriteZeile1 - nie uywane

%*DEFINE (WriteZeile1(Text))LOCAL WriteZeile1Text (
	call	LCDOutStrZeile1
%WriteZeile1Text	db	%Text,0
)

;=================================================================  WriteZeile2  - nie uywane

%*DEFINE (WriteZeile2(Text))LOCAL WriteZeile2Text (
	call	LCDOutStrZeile2
%WriteZeile2Text	db	%Text,0
)

;=================================================================  WriteByteXY  - nie uywane

%*DEFINE (WriteByteXY(x,y,Byte))(
	push	acc
	mov	a,#(%x-1) + ((%y-1) * 40h)
	call	LCDPos
	mov	a,%Byte
	call	LCDOutByte
	pop	acc
)

;#################### Ende der Macros  ############################

;#################### Begin des LCD Moduls ########################
;------------------------------------------------------------------
;Initialisierung der LCD Anzeige
;Bei der Initialisierung muessen Wartezeiten eingehalten werden
;Bei Reduzierung auf 4 Bitbreite muss das Initialisierungsbyte kurz
;hintereinander zuerst der hohe und dann der niederwertige Teil des Bytes
;ausgegeben werden
;InitilalisierungByte = 00101000B
;Bit4  1= 8 Bit Breite, 0= 4 Bit Breite
;Bit3  1= 2 Zeilen,     0= 1 Zeile

;Initialisierung erfolgt 3 mal in verschiedenen Zeitabstaenden
;15 mSek dann 4,1 mSek und 100uSek

;Ausgabeport fuer LCDAnzeige
; LCDPort.0 = enable
; LCDPort.1 = R/W
; LCDPort.2 = RS
; LCDPort.3 = frei
; LCDPort.4 - LCDPort.7 = Daten 0-4
; hier Ausgabeport festlegen und EnableBit
;================================================
LCDPort		equ	Port1		;virtueller Port (Emulator)
LCDEnable	bit	LCDPort.0
;================================================
;Function Set: 4 bit Datenbreite; 2 Zeilen                                   ===========================;swj  4 bitowy interfejs 2 linijkowy LCD
ib1	equ	00100000b	;Function set 1. nibel  4.Bitmodus
ib2	equ	10000000b	;Function set 2. nibel
;================================================
;Entry Mode Set: increment, display shift
; d7 d6 d5 d4 d3 d2 d1 d0
;  0  0  0  0  0  1 I/D S
; I/D 1= increment	0= decrement
; S   1= display shift	0= display freeze
ib3	equ	00000110b	;Bit1=I/D, Bit0=S
;================================================
;Display on/off control: display on, cursor off , cursor not blink
; d7 d6 d5 d4 d3 d2 d1 d0
;  0  0  0  0  1  D  C  B
; D	1= display on		0= display off
; C	1= cursor on		0= cursor off
; B	1= cursor blink		0= cursor not blink
ib4	equ	00001100b	;Bit2=D, Bit1=C, Bit0=B
;================================================
;Cursor Display shift: display shift, right shift
; d7 d6 d5 d4 d3  d2 d1 d0
;  0  0  0  1 S/C F/L *  *
; S/C	1= display shift	0= cursor move
; F/L	1= right shift		0= left shift
ib5	equ	00010100b	;Bit3=S/C, Bit2=R/L
;================================================
	CSEG

LCDInit:
	clr	LCDPort.0 	;Enable deaktivieren

	MOV	dph,#1eh		;warten > 15 mSek h1e = 30dec 
	mov	dpl,#00h
lcdinit1:
	djnz	dpl,$
	djnz	dph,lcdinit1

	mov	a,#ib1		;Einstellen der Interfacefunktion 4Bit breite
	call	LCDAusgabe
	mov	a,#ib2		;Einstellen der Interfacefunktion 4Bit breite
	call	LCDAusgabe

	MOV	dph,#0fh		;warten > 4,1 mSek 08h  xxxx   czekaj 8ms   0fh
	mov	dpl,#00h
lcdinit2:
	djnz	dpl,$
	djnz	dph,lcdinit2

	mov	a,#ib1		;Einstellen der Interfacefunktion 4Bit breite
	call	LCDAusgabe
	mov	a,#ib2		;Einstellen der Interfacefunktion 4Bit breite
	call	LCDAusgabe

	MOV	dph,#01h	;warten > 100 uSek 
	mov	dpl,#033h
lcdinit3:
	djnz	dpl,$
	djnz	dph,lcdinit3

	mov	a,#ib3
	call	LCDCom
	mov	a,#ib4		;Bit2=D, Bit1=C, Bit0=B
	call	LCDCom
	mov	a,#ib5		;Bit3=S/C, Bit2=R/L
	call	LCDCom
	ret

;----------------------------------------------------------
;An Enable der LCD wird ein positiver Impuls
;zur Uebernahme der Daten erzeugt

Enable:
	setb	LCDEnable	;Enableimpuls an LCD erzeugen
	clr	LCDEnable
	ret
;--------------------------------------------------------------------
;Ausgabe eines LCD-Commandos zur Steuerung der LCD
;RS  = 0
;R/W = 0
LCDCom:
	push	acc
LCDCom1:
	call	LCDRdy		;warten bis LCD bereit
	push	acc			;Register A merken
	anl	a,#11110000b	;nur oberes Nibbel
	call	LCDAusgabe
	pop	acc			;gemerktes Register holen
	swap	a			;Nibbel tauschen
	anl	a,#11110000b	;nur oberse Nibbel
	call	LCDAusgabe
	pop	acc
	ret
;--------------------------------------------------------------------
LCDDisplayClear:
	push	acc
	mov	a,#00000001b	;fertiger befehl
	sjmp	LCDCom1

LCDCursorHome:
	push	acc
	mov	a,#00000010b	;fertiger befehl
	sjmp	LCDCom1

LCDHomeZeile1:
	push	acc
	mov	a,#80H		;d7 vorsichthalber auf high setzen da BF bit
	sjmp	LCDCom1

LCDHomeZeile2:
	push	acc
	mov	a,#0C0H		;d7 vorsichthalber auf high setzen da BF bit
	sjmp	LCDCom1

LCDShiftRechts:
	push	acc
	mov	a,#00011000b	;Display nach rechts verschieben
	sjmp	LCDCom1

LCDShiftLinks:
	push	acc
	mov	a,#00011100b	;Display nach links verschieben
	sjmp	LCDCom1

LCDEntryShift:
	push	acc
	mov	a,#00000111b	;Display automatisch beim Schreiben
	sjmp	LCDCom1		;nach links verschieben

LCDPos:
	push	acc
	orl	a,#80h		;d7 setzen
	sjmp	LCDCom1

;--------------------------------------------------------------------
;lesen des Statusbits der LCD-anzeige
;BS  = 0
;R/W = 1

LCDRdy:
	push	acc				;A merken
	anl	LCDPort,#11111010b	;LCD zum lesen vorbereiten
	orl	LCDPort,#11110010b	;Bit 3 nicht veraendern
LCDRdy1:
	setb	LCDEnable
	mov	a,LCDPort			;erstes Nibel holen
	clr	LCDEnable			;und auswerten
	setb	LCDEnable
	clr	LCDEnable			;zweites Nibel holen
	jb	acc.7,LCDRdy1		;BF bit auswerten (ob LCD beschaeftigt)
	pop	acc				;A wieder restaurieren
	ret

;--------------------------------------------------------------------
;Ausgabe eines Char auf dem Display
;RS  = 1
;R/W = 0

LCDChar:
	push	acc
LCDChar1:
	Call	LCDRdy		;warten bis LCD bereit
	push	acc			;Register A merken
	anl	a,#11110000b	;oberes Nibbel ausgeben unteres Nibbel
	orl	a,#00000100b	;Steuersignale addieren
	call	LCDAusgabe
	pop	acc			;Register A zurueck
	swap	a			;Nibbel tauschen
	anl	a,#11110000b	;
	orl	a,#00000100b	;Steuersignale addieren
	call	LCDAusgabe
	pop	acc
	ret

LCDAusgabe:
	orl	a,#00001000b
	anl	LCDPort,a		;Ausgeben an Port
	anl	a,#11110111b	;Bit 3 nicht veraendern
	orl	LCDPort,a		;Ausgeben an Port
	jmp	enable		;LCD Uebernahme und ret
;--------------------------------------------------------------------
;Funktion	Ausgabe eines Leerzeichen auf dem Display

LCDSpace:
	push	acc
	mov	a,#' '
	sjmp	LCDChar1
;--------------------------------------------------------------------
;Ausgabe eines Strings auf der LCD Zeile1 oder Zeile2
;Speicheradresse des Strings im Codesegment steht in DPTR
;String muss mit einer 0 abgeschlossen sein


LCDOutStrZeile1:
	call	LCDHomeZeile1		;LCD-Adr Zeile1 laden
LCDStr:
LCDStringZ14:
	push	acc			;Reg A merken da ueberschrieben wird
	dec	sp
	pop	dph
	pop	dpl
	inc	sp
	inc	sp
	inc	sp
LCDStringZ13:
	mov	a,#0
	movc	a,@a+dptr		;Zeichen aus Codeseg in A laden
	cjne	a,#0,LCDStringZ12	;? ist es eine 0
	inc	dptr
	dec	sp
	dec	sp
	dec	sp
	push	dpl
	push	dph
	inc	sp
	pop	acc			;ja
	ret

LCDStringZ12:				;nein
	cjne	a,#1Fh,LCDStringZ16	;Zeichen
LCDStringZ16:
	jc	LCDStringZ15		;Zeichen < 1Fh
	call	LCDChar			;nein Ausgabe des Zeichens
LCDStringZ15:
	cjne	a,#2,LS17
	inc	dptr
	mov	a,#0
	movc	a,@a+dptr		;Zeichen aus Codeseg in A laden
	call	LCDPos			;Position laden
LS17:
	inc	dptr			;Zeiger eins weiter
	sjmp	LCDStringZ13		;Ausgabe fortsetzen

LCDOutStrZeile2:
	call	LCDHomeZeile2		;LCD-Adr Zeile2 laden
	sjmp	LCDStringZ14		;zur Ausgabe sprimgen

;--------------------------------------------------------------------
BCDToAscii:
	anl	a,#00001111b	;nur unteres Nibbel
	inc	a               ;Offset
	movc	a,@a+PC		;Wert holen
	ret
	DB	'0123456789ABCDEF'



;Funktion	Ausgabe des Registers A auf dem Display in hexadezimaler Form
;In		Byte in Reg A
;Out		Hexanzeige in LCD, Byte in Reg A
;Register	A

LCDOutByteNibbel:
	call	BCDToAscii	;wandeln
	call	LCDChar		;und ausgeben
	ret

LCDOutByte:
	push	psw
	push	acc
	swap	a			;Nibbel tauschen
	call	LCDOutByteNibbel        ;hoeherwertigen 4 Bit ausgeben
	pop	acc
	call	LCDOutByteNibbel        ;unteren 4 Bit ausgeben
	pop	psw
	ret

;--------------------------------------------------------------------
;Funktion	Ausgabe der R-register auf der 1. Zeile auf dem Display
;		beginnend mit r0 r1 r2 r3 r4 r5 r6 r7 in hexadezimaler Form
;In
;Out
;Register

LCDRegRZeile1:
	push	acc
	call	LCDHomeZeile1
	sjmp	br1

;Funktion	Ausgabe der R-register auf der 2. Zeile auf dem Display
;		beginnend mit r0 r1 r2 r3 r4 r5 r6 r7 in hexadezimaler Form
;In
;Out
;Register

LCDRegRZeile2:
	push	acc
	call	LCDHomeZeile2
br1:
	mov	a,r0
	call	LCDOutByte
	call	LCDSpace
	mov	a,r1
	call	LCDOutByte
	call	LCDSpace
	mov	a,r2
	call	LCDOutByte
	call	LCDSpace
	mov	a,r3
	call	LCDOutByte
	call	LCDSpace
	mov	a,r4
	call	LCDOutByte
	call	LCDSpace
	mov	a,r5
	call	LCDOutByte
	call	LCDSpace
	mov	a,r6
	call	LCDOutByte
	call	LCDSpace
	mov	a,r7
	call	LCDOutByte
	pop	acc
	ret

;--------------------------------------------------------------------
;Funktion	Ausgabe von "1" oder "0" jenachdem ob C-Flag gesetzt
;In		C-Flag
;Out
;Register

LCDCBit:
	jc	LCDHigh
	sjmp	LCDLow

LCDHigh:
	push	acc
	mov	a,#'1'
LCDHigh1:
	call	LCDChar
	pop	acc
	ret
LCDLow:
	push	acc
	mov	a,#'0'
	sjmp	LCDHigh1
;--------------------------------------------------------------------------
;Funktion	Ausgabe der Reg PSW,SP,DPTR auf dem Display
;		In Zeile1 oder Zeile2

LCDRegCPUZeile1:
	push	acc
	push	psw
	call	LCDHomeZeile1
	sjmp	LCDRCZ

LCDRegCPUZeile2:
	push	acc
	push	psw
	call	LCDHomeZeile2
LCDRCZ:
	mov	a,psw
	call	LCDOutByte
	call	LCDSpace
	pop	psw
	pop	acc
	push	acc
	call	LCDOutByte
	call	LCDSpace
	mov	a,sp
	call	LCDOutByte
	call	LCDSpace
	push	dpl
	push	dph
	mov	a,dph
	call	LCDOutByte
	call	LCDSpace
	mov	a,dpl
	call	LCDOutByte
	pop	dph
	pop	dpl
	pop	acc
	ret
;---------------------------------------------------------------------------
;Funktion	Ausgabe der Register auf dem Display
;		Zeile1 R-Register
;		Zeile2 CPU-Register PSW,SP,DPTR

LCDRegister:
	Call	LCDRegRZeile1		;R auf Zeile 1
	jmp	LCDRegCPUZeile2		;PSW auf Zeile 2
;---------------------------------------------------------------------------
;Funktion	Ausgabe der Register auf dem Display + Stop mit Software
;		Zeile1 R-Register
;		Zeile2 CPU-Register PSW,SP,DPTR

LCDRegisterStop:
	Call	LCDRegister		;Register anzeigen
	sjmp	$			;Endlosschleife
;---------------------------------------------------------------------------
;

sleep:	mov	dph,#0
	mov	dpl,dph
	mov	r0,#20
sleep1:
	djnz	dpl,sleep1
	djnz	dph,sleep1
	djnz	r0,sleep1
	call	LCDDefineSonderzeichen
	call	LCDDisplayClear
        ret

;---------------------------------------------------------------------------
;Funktion	Definieren eigener Ascii-Zeichen im Adressbereich 0-7
;In		In DPTR Tabelle im Codebereich, in A Speicherplatz 0..7
;Out		Zeichen in der LCD definiert
;Register	DPTR, R0, A, B

LCDDefine:
	push	acc
	mov	r0,#8			;Schleifenzaehler = 8
	mov	b,#8			;Speicherplatz in 8 ter Schritten
	mul	ab
	orl	a,#40h			;OR Befehl fuer Ascii-Programmierung
	call	LCDCom
LCDDefine1:
	mov	a,#0
	movc	a,@a+dptr		;Zeichen aus Codeseg in A laden
	call	LCDChar
	inc	dptr			;das naechste Zeichen
	djnz	r0,LCDDefine1	        ;insgesamt 8 Zeichen
	pop	acc
	ret

;Funktion	Alle Sonderzeichen in LCD laden

LCDDefineSonderzeichen:
	push	acc
	push	dpl
	push	dph
	mov	a,#0
	mov	r1,#8
	mov	dptr,#TabelleSonderzeichen
LCDSon1:
	call	LCDDefine
	inc	a
	djnz	r1,LCDSon1
	pop	dph
	pop	dpl
	pop	acc
	ret

TabelleSonderzeichen:
Sonderzeichen1:
	db	00000010b
	db	00000100b
	db	00001000b
	db	00011111b
	db	00001000b
	db	00000100b
	db	00000010b
	db	00000000b

Sonderzeichen2:
	db	00001000b
	db	00000100b
	db	00000010b
	db	00011111b
	db	00000010b
	db	00000100b
	db	00001000b
	db	00000000b

Sonderzeichen3:
	db	00000000b
	db	00010001b
	db	00001010b
	db	00000100b
	db	00001010b
	db	00010001b
	db	00000000b
	db	00000000b

Sonderzeichen4:
	db	00000000b
	db	00000000b
	db	00000001b
	db	00000010b
	db	00010100b
	db	00001000b
	db	00000000b
	db	00000000b

Sonderzeichen5:
	db	00000110b
	db	00001010b
	db	00000010b
	db	00000000b
	db	00000110b
	db	00001001b
	db	00001001b
	db	00000110b

Sonderzeichen6:
	db	00011111b
	db	00011111b
	db	00011111b
	db	00011111b
	db	00011111b
	db	00011111b
	db	00011111b
	db	00011111b

Sonderzeichen7:
	db	00011111b
	db	00011111b
	db	00011111b
	db	00011111b
	db	00011111b
	db	00011111b
	db	00011111b
	db	00011111b

Sonderzeichen8:
	db	00011111b
	db	00011111b
	db	00011111b
	db	00011111b
	db	00011111b
	db	00011111b
	db	00011111b
	db	00011111b



;###################### Ende des LCD-Moduls #########################
