Attribute VB_Name = "mdMain"
Option Explicit
Public Const WARNMSG01 = "The  'Analyer'  program is already running"
Public Const PATH_DEFAULT_INSTALLATION = "c:\Analyzer\" ' DEFAULT directory for Debug
Public Const WARNMSG00 = "At least a monitor resolution of 800x600 pixels and small characters (96 dpi) are suggested for this program."
Public Const WARNMSG_TITLE = "Warning"
Public Declare Function GetTickCount Lib "kernel32.dll" () As Long

Public Declare Function GetPrivateProfileint Lib "kernel32" Alias "GetPrivateProfileIntA" _
  (ByVal lpApplicationName As String, _
  ByVal lpKeyName As Any, _
  ByVal lpDefault As Integer, _
  ByVal lpFileName As String) As Long
  
Declare Function WritePrivateProfileString Lib "kernel32" _
Alias "WritePrivateProfileStringA" (ByVal lpApplicationName _
As String, ByVal lpKeyName As Any, ByVal lpString As Any, _
ByVal lpFileName As String) As Long
  
Public Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Public Declare Sub Sleep Lib "kernel32" (ByVal dwMiliseconds As Long)
'utilizzata per ricavare l'ambiente(sviluppo o running)
Public Declare Function GetModuleFileName Lib "kernel32" Alias "GetModuleFileNameA" (ByVal hModule As Long, ByVal lpFileName As String, ByVal nSize As Long) As Long
Public Declare Function Inp Lib "inpout32.dll" _
Alias "Inp32" (ByVal PortAddress As Integer) As Integer
Public Declare Sub Out Lib "inpout32.dll" _
Alias "Out32" (ByVal PortAddress As Integer, ByVal Value As Integer)


Public address1 As Integer
Public address2 As Integer

Public colorS1 As Single
Public colorS2 As Single
Public colorS3 As Single
Public colorS4 As Single
Public colorS5 As Single
Public colorS6 As String
Public return_loss() As Single
Public angle() As Single

Public sFMax As Single
Public sFMin As Single
Public sFMaxDef As Single
Public sFMinDef As Single
Public lChamp As Long
Public iStep As Integer
Public InputVelFactor As Single

Sub Main()
Dim X As Long, p As Integer
Dim response As String
Dim strPathInstallation As String

'test for more than one instance of program running
If App.PrevInstance Then
    Beep
    response = MsgBox(WARNMSG01, vbExclamation, WARNMSG_TITLE)
    End ' exit from program
End If

frmSplash.Show
DoEvents
Sleep (2000)

' test of screen resolution 800x600 or greater
Call LeggiFileIni
If (Screen.Width < 12000) And (Screen.Height < 9000) Then
    Beep
    response = MsgBox(WARNMSG00, vbExclamation, WARNMSG_TITLE)
End If

' application path initialisation
strPathInstallation = App.Path & "\" 'returns path of EXE file

'Determine if VB environment
If VBDesignEnvironment() = 1 Then
    strPathInstallation = PATH_DEFAULT_INSTALLATION
End If

chart1.Show

Unload frmSplash

End Sub
Function VBDesignEnvironment() As Integer
    
    Dim strFileName As String
    Dim lngCount As Long
    Dim strVB As String
    
    strFileName = String(255, 0)
    
    lngCount = GetModuleFileName(App.hInstance, strFileName, 255)
    strFileName = Left(strFileName, lngCount)
    strVB = Mid(UCase(Right(strFileName, 7)), 1, 2)
    If strVB <> "VB" Then
        VBDesignEnvironment = 0
    Else
        VBDesignEnvironment = 1 'VB environment
    End If
End Function
Sub LeggiFileIni()
Dim lngRet As Long
Dim strIniPath As String
Dim temp As String
Dim ret As String

temp = String(50 + 1, 0)
strIniPath = App.Path

sFMax = GetPrivateProfileint("PARAMETERS", "FMax", 10000, App.Path & "\analyz.ini")
sFMin = GetPrivateProfileint("PARAMETERS", "FMin", 10000, App.Path & "\analyz.ini")
lChamp = GetPrivateProfileint("PARAMETERS", "Champ", 6000, App.Path & "\analyz.ini")
iStep = GetPrivateProfileint("PARAMETERS", "Step", 1, App.Path & "\analyz.ini")
colorS1 = GetPrivateProfileint("GRAF_PROP", "colorS1", 0, App.Path & "\analyz.ini")
colorS2 = GetPrivateProfileint("GRAF_PROP", "colorS2", 0, App.Path & "\analyz.ini")
colorS3 = GetPrivateProfileint("GRAF_PROP", "colorS3", 0, App.Path & "\analyz.ini")
colorS4 = GetPrivateProfileint("GRAF_PROP", "colorS4", 0, App.Path & "\analyz.ini")
colorS5 = GetPrivateProfileint("GRAF_PROP", "colorS5", 0, App.Path & "\analyz.ini")
colorS6 = GetPrivateProfileint("GRAF_PROP", "colorS6", 0, App.Path & "\analyz.ini")

address1 = GetPrivateProfileint("PORTSETTING", "Address1", 0, App.Path & "\analyz.ini")
address2 = GetPrivateProfileint("PORTSETTING", "Address2", 0, App.Path & "\analyz.ini")
ret = GetPrivateProfileString("PARAMETERS", "InputVelFactor", "0.66", temp, Len(temp), App.Path & "\analyz.ini")
InputVelFactor = CSng(Left(temp, ret))

End Sub
