Program LCD_T1_T2_T3;
{ Program to count T1...values for LCD display.}
Uses
  Crt,DOS;
Var
  OK                  : Boolean;

  Position,
  Max,T1,T2,T3,T4,X   : Byte;

  A,B,C,D,N,M         : LongInt;

  Expected,InReality,
  Fx,Correction       : Real;

  Error               : Integer;

  S                   : String;

Label Finito;

Begin
  ClrScr;
  Correction:=1;
  OK:=False;
  If ParamCount=0 Then
    Begin
      WriteLn('====================== (C) OM3CPH 2000 ========================');
      WriteLn;
      WriteLn('Program to calculate T1,T2,T3 and X coefficients for LCD display');
      WriteLn('PIC frequency meter (4 wires data transfer mode).');
      WriteLn;
      WriteLn;
      WriteLn('Usage:    LCD4T123 [Xtal [expected in_reality]]');
      WriteLn('                    Xtal       is Xtal frequency in MHz');
      WriteLn('                    expected   equals to frequency of the standard');
      WriteLn('                    in_reality obtained frequency');
      WriteLn;
      WriteLn;
      WriteLn('Examples: LCD4T123 8.8         to calculate T1, T2, T3 , T4 and Z for 8.8 MHz Xtal');
      WriteLn;
      WriteLn('          LCD4T123 8.8 20 20.0005 to recalculate T1, T2, T3, T4 and Z for 8.8 MHz');
      WriteLn('                               Xtal if after first PIC programming different');
      WriteLn('                               value is displayed (20.0005) than expected (20).)');
      WriteLn;
      WriteLn;
      WriteLn('Press any key to continue...');
      Repeat Until KeyPressed;
      Halt;
    End;

  Val(ParamStr(1),Fx,Error);
  If ((Fx<0.5) Or (Fx>20)) Then
    Begin
      WriteLn;
      WriteLn('Xtal frequency should be larger than 500 kHz and smaller than 20 MHz!');
      WriteLn;
      WriteLn;
      WriteLn('Press any key to continue...');
      Repeat Until KeyPressed;
      Halt;
    End;

  If ParamCount=3 Then
    Begin
      Val(ParamStr(2),Expected,Error);
      Val(ParamStr(3),InReality,Error);
      Correction:=Expected/InReality;
    End;

  If ((Correction<0.5) Or (Correction>2)) Then
    Begin
      WriteLn;
      WriteLn('Do you really have ',Fx,' MHz Xtal?');
      WriteLn;
      WriteLn;
      WriteLn('Press any key to continue...');
      Repeat Until KeyPressed;
      Halt;
    End;

  N:=Round(Fx*25000);
  N:=Round(N/Correction);
  Max:=255;

  GoToXY(19,21);Write(' Please wait ...Ŀ');
  GoToXY(19,22);Write('                                        ');
  GoToXY(19,23);Write('');

  For T1:=Max DownTo 1 Do
    Begin
      S:='';
      For Position:=1 To (Round(40*((1+Max-T1)/Max))) Do S:=S+Chr(178);
      GoToXY(20,22);Write(S);
      For T2:=1 To Max Do
        For T3:=1 To Max Do
          For T4:=1 To 2 Do
            For X:=1 To 8 Do
              Begin
                A:=9*T1+4;
                A:=A*T2+4;
                A:=A*T3;
                A:=A+9*T4+1;
                A:=A+X;
                If A=N Then Begin OK:=True;GoTo Finito;End;
            End;
      End;

Finito:
  If OK Then
    Begin
      GoToXY(19,19);Write('Ŀ');
      GoToXY(19,20);Write('        Calculation completed.          ');
      GoToXY(19,21);Write('               T1  T2  T3  T4  X        ');
      GoToXY(19,22);Write('     Values :',T1:4,T2:4,T3:4,T4:4,X:3,'        ');
      GoToXY(19,23);Write('');
    End
  Else
    Begin
      GoToXY(19,20);Write('Ŀ');
      GoToXY(19,21);Write('        Calculation completed.          ');
      GoToXY(19,22);Write('        No solution found... :-(        ');
      GoToXY(19,23);Write('');
    End;
  ReadLn;
End.