Program LED_T1_T2_T3; { 8 digit variant.

Timing formula:

N = 250 000 * fx = 255*[(36 + 3*T1 + X)*8 + 2 + 3*T2 + Y] + 19 + 3*T3 + Z

X,Y is assumed ZERO!

N = 250 000 * fx = 255*[(36 + 3*T1)*8 + 2 + 3*T2] + 19 + 3*T3 + Z
}
Uses
  Crt,DOS;
Var
  Position,I,Max,T1,T2,T3,Z                : Byte;

  Expected,InReality,Fx,Correction         : Real;

  N,Result,M            : LongInt;

  Error                 : Integer;

  OK                    : Boolean;

  S                     : String;

  IncFile               : Text;

Label    Finito;

Begin
  ClrScr;Correction:=1;
  If ParamCount=0 Then
    Begin
      WriteLn('====================== (C) OM3CPH 2000 ========================');
      WriteLn;
      WriteLn('Program to calculate T1, T2, T3 and Z coefficients for 8 digit');
      WriteLn('LED display PIC frequency meter.');
      WriteLn;
      WriteLn;
      WriteLn('Program creates led8.inc and zled8.inc files with calculated values.');
      WriteLn;
      WriteLn('Usage:    LED8T123 [Xtal [expected in_reality]]');
      WriteLn('                    Xtal       is Xtal frequency in MHz');
      WriteLn('                    expected   equals to frequency of the standard');
      WriteLn('                    in_reality obtained frequency');
      WriteLn;
      WriteLn;
      WriteLn('Examples: LED8T123 8.8         to calculate T1, T2, T3 and Z for 8.8 MHz Xtal');
      WriteLn;
      WriteLn('          LED8T123 8.8 20 19.9995 to recalculate T1, T2, T3 and Z for 8.8 MHz');
      WriteLn('                               Xtal if after first PIC programming different');
      WriteLn('                               value is displayed (19.9995) than expected (20).)');
      WriteLn;
      WriteLn;
      WriteLn('Press any key to continue...');
      Repeat Until KeyPressed;
      Halt;
    End;

  Val(ParamStr(1),Fx,Error);

  If ((Fx<0.5) Or (Fx>20)) Then
    Begin
      WriteLn;
      WriteLn('Xtal frequency should be larger than 500 kHz and smaller than 20 MHz!');
      WriteLn;
      WriteLn('Press any key to continue...');
      Repeat Until KeyPressed;
      Halt;
    End;

  If ParamCount=3 Then
    Begin
      Val(ParamStr(2),Expected,Error);
      Val(ParamStr(3),InReality,Error);
      Correction:=Expected/InReality;
    End;

  If ((Correction<0.5) Or (Correction>2)) Then
    Begin
      WriteLn;
      WriteLn('Do you really have ',Fx,' MHz Xtal?');
      WriteLn;
      WriteLn('Press any key to continue...');
      Repeat Until KeyPressed;
      Halt;
    End;

  N:=Round(250000*Fx);
  N:=Round(N*Correction);

  Max:=255;
  GoToXY(19,21);Write(' Please wait ...Ŀ');
  GoToXY(19,22);Write('                                        ');
  GoToXY(19,23);Write('');

{ N = 250 000 * fx = 255*[(36 + 3*T1)*8 + 2 + 3*T2] + 19 + 3*T3 + Z }

  For T1:=Max DownTo 1 Do
    Begin
      S:='';
      For Position:=1 To (Round(40*((1+Max-T1)/Max))) Do S:=S+Chr(178);
      GoToXY(20,22);Write(S);
      For T2:=1 To Max Do
        For T3:=1 To Max Do
          For Z:=0 To 8 Do
            Begin
              Result:=36+3*T1;
              Result:=8*Result;
              Result:=Result+2+3*T2;
              Result:=Result*255;
              Result:=Result+19+3*T3;
              Result:=Result+Z;
             {WriteLn(N,'<->',Result);}
              If Result=N Then Begin OK:=True;GoTo Finito;End;
            End;
    End;
Finito:
  If OK Then
    Begin
      Assign(IncFile,'8led.inc');Rewrite(IncFile);
      GoToXY(19,19);Write('Ŀ');
      GoToXY(19,20);Write('        Calculation completed.          ');
      GoToXY(19,21);Write('              T1  T2  T3   Z            ');
      GoToXY(19,22);Write('    Values: ',T1:4,T2:4,T3:4,Z:4,'            ');
      GoToXY(19,23);Write('');
      WriteLn(IncFile,'T1          equ       .',T1);
      WriteLn(IncFile,'T2          equ       .',T2);
      WriteLn(IncFile,'T3          equ       .',T3);
      Close(IncFile);
      Assign(IncFile,'z8led.inc');Rewrite(IncFile);
      For I:=1 To Z Do WriteLn(IncFile,'          nop');
      Close(IncFile);
    End
  Else
    Begin
      GoToXY(19,19);Write('Ŀ');
      GoToXY(19,20);Write('        Calculation completed.          ');
      GoToXY(19,21);Write('        No solution found... :-(        ');
      GoToXY(19,22);Write('');
    End;
  WriteLn;
  WriteLn('Press any key to continue...');
  Repeat Until KeyPressed;
  ReadKey;
End.