Program LED_T1_T2_T3;{ Low frequency program parameters. }
Uses
  Crt,DOS;
Var
  Position,I,T,
  Max,T1,T2,T3,Z        : Byte;

  Expected,InReality,
  Fx,Correction         : Real;

  N,Result,M            : LongInt;

  Error                 : Integer;

  OK                    : Boolean;

  S                     : String;

Label    Finito;

Begin
  ClrScr;Correction:=1;
  If ParamCount=0 Then
    Begin
      WriteLn('====================== (C) OM3CPH 2000 ========================');
      WriteLn;
      WriteLn('Program to calculate T1, T2, T3 and Z coefficients for LED display');
      WriteLn('PIC UHF frequency meter.');
      WriteLn;
      WriteLn;
      WriteLn('Usage:    LEDXT123 [Xtal [expected in_reality]]');
      WriteLn('                    Xtal       is Xtal frequency in MHz');
      WriteLn('                    expected   equals to frequency of the standard');
      WriteLn('                    in_reality obtained frequency');
      WriteLn;
      WriteLn;
      WriteLn('Examples: LEDXT123 10         to calculate T1, T2, T3 and Z for 10 MHz Xtal');
      WriteLn;
      WriteLn('          LEDXT123 10 8.8 8.80192 to recalculate T1, T2, T3 and Z for 10 MHz');
      WriteLn('                               Xtal if after first PIC programming different');
      WriteLn('                               value is displayed (8.80192) than expected (8.8).)');
      WriteLn;
      WriteLn;
      WriteLn('Press any key to continue...');
      Repeat Until KeyPressed;
      Halt;
    End;

  Val(ParamStr(1),Fx,Error);

  If ((Fx<0.5) Or (Fx>20)) Then
    Begin
      WriteLn;
      WriteLn('Xtal frequency should be larger than 500 kHz and smaller than 20 MHz!');
      WriteLn;
      WriteLn('Press any key to continue...');
      Repeat Until KeyPressed;
      Halt;
    End;

  If ParamCount=3 Then
    Begin
      Val(ParamStr(2),Expected,Error);
      Val(ParamStr(3),InReality,Error);
      Correction:=Expected/InReality;
    End;

  If ((Correction<0.5) Or (Correction>2)) Then
    Begin
      WriteLn;
      WriteLn('Do you really have ',Fx,' MHz Xtal?');
      WriteLn;
      WriteLn('Press any key to continue...');
      Repeat Until KeyPressed;
      Halt;
    End;

  N:=Round(25000*Fx);
  N:=Round(N*Correction);

  Max:=255;OK:=False;
  GoToXY(19,21);Write(' Please wait ...Ŀ');
  GoToXY(19,22);Write('                                        ');
  GoToXY(19,23);Write('');

{ 64 000*Fx=T*[7*(34+3*T1)+6+3*T2]+10+9*T3+Z }

  For T:=80 DownTo 40 Do
  For T1:=Max DownTo 1 Do
    Begin
      S:='';
      For Position:=1 To (Round(40*((1+80-T)/(80-40)))) Do S:=S+Chr(178);
      GoToXY(20,22);Write(S);
      For T2:=1 To Max Do
        For T3:=1 To 10 Do
          For Z:=0 To 8 Do
            Begin
              Result:=34+3*T1;
              Result:=7*Result;
              Result:=Result+6+3*T2;
              Result:=Result*T;
              Result:=Result+10+9*T3;
              Result:=Result+Z;
              If Result=N Then
                If T3<10 Then Begin OK:=True;GoTo Finito;End;
            End;
    End;
Finito:
  If OK Then
    Begin
      GoToXY(19,19);Write('Ŀ');
      GoToXY(19,20);Write('        Calculation completed.          ');
      GoToXY(19,21);Write('          T   T1  T2  T3   Z            ');
      GoToXY(19,22);Write(' Values: ',T:4,T1:4,T2:4,T3:4,Z:4,'           ');
      GoToXY(19,23);Write('');
    End
  Else
    Begin
      GoToXY(19,19);Write('Ŀ');
      GoToXY(19,20);Write('        Calculation completed.          ');
      GoToXY(19,21);Write('        No solution found... :-(        ');
      GoToXY(19,22);Write('');
    End;
  WriteLn;
  WriteLn('Press any key to continue...');
  Repeat Until KeyPressed;
  ReadKey;
End.